/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.publish.auth.maven;

import java.io.File;
import org.dom4j.Element;
import org.hibernate.build.gradle.publish.auth.maven.DomHelper;
import org.hibernate.build.gradle.publish.auth.maven.PasswordReader;
import org.hibernate.build.gradle.publish.auth.maven.PathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class PasswordReaderFactory {
    private static final Logger log = LoggerFactory.getLogger(PasswordReaderFactory.class);
    public static final PasswordReaderFactory INSTANCE = new PasswordReaderFactory();

    public PasswordReader determinePasswordReader() {
        File securitySettingsFile = this.determineSecuritySettingsFileLocation();
        String masterPasswordEntry = securitySettingsFile.exists() ? this.extractMasterPassword(securitySettingsFile) : null;
        log.trace("master password entry : " + masterPasswordEntry);
        return masterPasswordEntry == null ? new BasicPasswordReader() : new PlexusCipherPasswordReader(masterPasswordEntry);
    }

    private String extractMasterPassword(File securitySettingsFile) {
        try {
            SettingsSecurity settingsSecurity = SecUtil.read((String)securitySettingsFile.getAbsolutePath(), (boolean)true);
            return settingsSecurity == null ? null : settingsSecurity.getMaster();
        }
        catch (SecDispatcherException e) {
            log.warn("Unable to read Maven security settings file", (Throwable)e);
            return null;
        }
    }

    private File determineSecuritySettingsFileLocation() {
        String defaultLocation = "~/.m2/settings-security.xml";
        String location = System.getProperty("settings.security", "~/.m2/settings-security.xml");
        return new File(PathHelper.normalizePath(location));
    }

    public static class PlexusCipherPasswordReader
    implements PasswordReader {
        private static final Logger log = LoggerFactory.getLogger(PlexusCipherPasswordReader.class);
        private final DefaultPlexusCipher cipher = PlexusCipherPasswordReader.buildCipher();
        private final String master;

        public PlexusCipherPasswordReader(String master) {
            this.master = PlexusCipherPasswordReader.decryptMaster(master, this.cipher);
        }

        private static DefaultPlexusCipher buildCipher() {
            try {
                return new DefaultPlexusCipher();
            }
            catch (PlexusCipherException e) {
                log.error("Unable to create PlexusCipher in order to decrypt Maven passwords");
                return null;
            }
        }

        private static String decryptMaster(String master, DefaultPlexusCipher cipher) {
            try {
                return cipher.decryptDecorated(master, "settings.security");
            }
            catch (PlexusCipherException e) {
                log.error("Unable to create PlexusCipher in order to decrypt Maven passwords");
                return null;
            }
        }

        @Override
        public String readPassword(Element passwordElement) {
            String value = DomHelper.extractValue(passwordElement);
            try {
                return this.cipher.decryptDecorated(value, this.master);
            }
            catch (PlexusCipherException e) {
                log.warn("Unable to decrypt Maven password using PlexusCipher", (Throwable)e);
                return value;
            }
        }
    }

    public static class BasicPasswordReader
    implements PasswordReader {
        @Override
        public String readPassword(Element passwordElement) {
            return DomHelper.extractValue(passwordElement);
        }
    }
}

