/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.net;

import java.net.InetAddress;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslog;
import org.graylog2.syslog4j.impl.net.AbstractNetSyslogConfigIF;
import org.graylog2.syslog4j.util.SyslogUtility;

public abstract class AbstractNetSyslog
extends AbstractSyslog {
    private static final long serialVersionUID = -3250858945515853967L;
    protected static final Object cachedHostAddressSyncObject = new Object();
    protected InetAddress cachedHostAddress = null;
    protected AbstractNetSyslogConfigIF netSyslogConfig = null;

    protected void initialize() throws SyslogRuntimeException {
        try {
            this.netSyslogConfig = (AbstractNetSyslogConfigIF)this.syslogConfig;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must implement interface AbstractNetSyslogConfigIF");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getHostAddress() {
        InetAddress hostAddress = null;
        if (this.netSyslogConfig.isCacheHostAddress()) {
            if (this.cachedHostAddress == null) {
                Object object = cachedHostAddressSyncObject;
                synchronized (object) {
                    if (this.cachedHostAddress == null) {
                        this.cachedHostAddress = SyslogUtility.getInetAddress(this.syslogConfig.getHost());
                    }
                }
            }
            hostAddress = this.cachedHostAddress;
        } else {
            hostAddress = SyslogUtility.getInetAddress(this.syslogConfig.getHost());
        }
        return hostAddress;
    }
}

