/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.NameAwareMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;

public class ProxyUnwrappingMarshaller<C extends Converter>
implements ObjectMarshaller<C>,
NameAwareMarshaller {
    private static final String HIBERNATE_LAZY_INITIALIZER_PROP = "hibernateLazyInitializer";
    private static final String IMPLEMENTATION_PROP = "implementation";

    @Override
    public boolean supports(Object object) {
        if (object == null) {
            return false;
        }
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(object.getClass());
        return mc.hasProperty(object, HIBERNATE_LAZY_INITIALIZER_PROP) != null;
    }

    @Override
    public void marshalObject(Object object, C converter) throws ConverterException {
        Object unwrapped = this.unwrap(object);
        converter.lookupObjectMarshaller(unwrapped).marshalObject(unwrapped, (Converter)converter);
    }

    private Object unwrap(Object o) {
        if (o == null) {
            return o;
        }
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        MetaClass mc = registry.getMetaClass(o.getClass());
        Object hibernateLazyInitializer = mc.getProperty(o, HIBERNATE_LAZY_INITIALIZER_PROP);
        return registry.getMetaClass(hibernateLazyInitializer.getClass()).getProperty(hibernateLazyInitializer, IMPLEMENTATION_PROP);
    }

    @Override
    public String getElementName(Object o) {
        return GrailsNameUtils.getPropertyName((String)this.unwrap(o).getClass().getName());
    }
}

