/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.grails.lifecycle.ShutdownOperations;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.configuration.ConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.configuration.DefaultConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;

public class ConvertersConfigurationHolder {
    public static final String CONVERTERS_DEFAULT_ENCODING = "UTF-8";
    private static ConvertersConfigurationHolder INSTANCE;
    private final ConcurrentMap<Class<? extends Converter>, ConverterConfiguration> defaultConfiguration = new ConcurrentHashMap<Class<? extends Converter>, ConverterConfiguration>();
    private final ConcurrentMap<Class<? extends Converter>, Map<String, ConverterConfiguration>> namedConfigurations = new ConcurrentHashMap<Class<? extends Converter>, Map<String, ConverterConfiguration>>();
    private ThreadLocal<Map<Class<? extends Converter>, ConverterConfiguration>> threadLocalConfiguration = ConvertersConfigurationHolder.createThreadLocalConfiguration();

    protected static ThreadLocal<Map<Class<? extends Converter>, ConverterConfiguration>> createThreadLocalConfiguration() {
        return new ThreadLocal<Map<Class<? extends Converter>, ConverterConfiguration>>(){

            @Override
            protected Map<Class<? extends Converter>, ConverterConfiguration> initialValue() {
                return new HashMap<Class<? extends Converter>, ConverterConfiguration>();
            }
        };
    }

    private ConvertersConfigurationHolder() {
    }

    public static void clear() {
        ConvertersConfigurationHolder configurationHolder = ConvertersConfigurationHolder.getInstance();
        configurationHolder.defaultConfiguration.clear();
        configurationHolder.namedConfigurations.clear();
        configurationHolder.threadLocalConfiguration = ConvertersConfigurationHolder.createThreadLocalConfiguration();
    }

    public static <C extends Converter> void setDefaultConfiguration(Class<C> c, ConverterConfiguration<C> cfg) {
        ConvertersConfigurationHolder.getInstance().defaultConfiguration.put(c, cfg);
    }

    public static <C extends Converter> void setDefaultConfiguration(Class<C> c, List<ObjectMarshaller<C>> om) {
        ConvertersConfigurationHolder.getInstance().defaultConfiguration.put(c, new DefaultConverterConfiguration<C>(om));
    }

    private static ConvertersConfigurationHolder getInstance() throws ConverterException {
        return INSTANCE;
    }

    public static <C extends Converter> ConverterConfiguration<C> getConverterConfiguration(Class<C> converterClass) throws ConverterException {
        ConverterConfiguration existing;
        ConverterConfiguration cfg = ConvertersConfigurationHolder.getThreadLocalConverterConfiguration(converterClass);
        if (cfg == null && (cfg = (DefaultConverterConfiguration)ConvertersConfigurationHolder.getInstance().defaultConfiguration.get(converterClass)) == null && (existing = (ConverterConfiguration)ConvertersConfigurationHolder.getInstance().defaultConfiguration.putIfAbsent(converterClass, cfg = new DefaultConverterConfiguration())) != null) {
            cfg = existing;
        }
        return cfg;
    }

    public static <C extends Converter> ConverterConfiguration<C> getNamedConverterConfiguration(String name, Class<C> converterClass) throws ConverterException {
        Map<String, ConverterConfiguration> map = ConvertersConfigurationHolder.getNamedConfigMapForConverter(converterClass, false);
        return map != null ? map.get(name) : null;
    }

    public static <C extends Converter> ConverterConfiguration<C> getThreadLocalConverterConfiguration(Class<C> converterClass) throws ConverterException {
        return ConvertersConfigurationHolder.getInstance().threadLocalConfiguration.get().get(converterClass);
    }

    public static <C extends Converter> void setThreadLocalConverterConfiguration(Class<C> converterClass, ConverterConfiguration<C> cfg) throws ConverterException {
        ConvertersConfigurationHolder.getInstance().threadLocalConfiguration.get().put(converterClass, cfg);
    }

    public static <C extends Converter> void setNamedConverterConfiguration(Class<C> converterClass, String name, ConverterConfiguration<C> cfg) throws ConverterException {
        ConvertersConfigurationHolder.getNamedConfigMapForConverter(converterClass, true).put(name, cfg);
    }

    private static <C extends Converter> Map<String, ConverterConfiguration> getNamedConfigMapForConverter(Class<C> clazz, boolean create) {
        HashMap namedConfigs = (HashMap)ConvertersConfigurationHolder.getInstance().namedConfigurations.get(clazz);
        if (namedConfigs == null && create) {
            namedConfigs = new HashMap();
            ConvertersConfigurationHolder.getInstance().namedConfigurations.put(clazz, namedConfigs);
        }
        return namedConfigs;
    }

    public static <C extends Converter> void setNamedConverterConfiguration(Class<C> converterClass, String name, List<ObjectMarshaller<C>> om) throws ConverterException {
        ConvertersConfigurationHolder.getNamedConfigMapForConverter(converterClass, true).put(name, new DefaultConverterConfiguration<C>(om));
    }

    static {
        ShutdownOperations.addOperation((Runnable)new Runnable(){

            @Override
            public void run() {
                ConvertersConfigurationHolder.clear();
            }
        });
        INSTANCE = new ConvertersConfigurationHolder();
    }
}

