/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

final class PolyglotEngineException
extends RuntimeException {
    final RuntimeException e;

    private PolyglotEngineException(RuntimeException e) {
        super(null, e);
        this.e = e;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    static void rethrow(Throwable e) {
        if (e instanceof PolyglotEngineException) {
            throw ((PolyglotEngineException)e).e;
        }
    }

    static PolyglotEngineException illegalArgument(IllegalArgumentException e) {
        return new PolyglotEngineException(e);
    }

    static PolyglotEngineException illegalArgument(String message) {
        return new PolyglotEngineException(new IllegalArgumentException(message));
    }

    static PolyglotEngineException illegalState(String message) {
        return new PolyglotEngineException(new IllegalStateException(message));
    }

    static PolyglotEngineException nullPointer(String message) {
        return new PolyglotEngineException(new NullPointerException(message));
    }

    static PolyglotEngineException unsupported(String message) {
        return new PolyglotEngineException(new UnsupportedOperationException(message));
    }

    static PolyglotEngineException unsupported(String message, Throwable cause) {
        return new PolyglotEngineException(new UnsupportedOperationException(message, cause));
    }

    static PolyglotEngineException classCast(String message) {
        return new PolyglotEngineException(new ClassCastException(message));
    }

    static PolyglotEngineException arrayIndexOutOfBounds(String message) {
        return new PolyglotEngineException(new ArrayIndexOutOfBoundsException(message));
    }
}

