/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.macho;

import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.io.OutputAssembler;
import com.oracle.objectfile.macho.ARM64Reloc;
import com.oracle.objectfile.macho.MachOObjectFile;
import com.oracle.objectfile.macho.MachORelocationElement;
import com.oracle.objectfile.macho.MachORelocationType;
import com.oracle.objectfile.macho.MachOSymtab;
import com.oracle.objectfile.macho.X86_64Reloc;
import java.util.Map;
import java.util.Objects;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;

final class MachORelocationInfo
implements ObjectFile.RelocationRecord,
ObjectFile.RelocationMethod {
    private final MachORelocationElement containingElement;
    private final MachOObjectFile.MachOSection relocatedSection;
    private final MachORelocationType kind;
    private final int sectionOffset;
    private final ObjectFile.Symbol sym;
    private final MachOObjectFile.MachOSection targetSection;
    private final byte log2length;
    private final int addend;

    private MachORelocationInfo(MachORelocationElement containingElement, MachOObjectFile.MachOSection relocatedSection, int offset, int requestedLength, MachORelocationType kind, String symbolName, boolean asLocalReloc, int addend) {
        this.containingElement = containingElement;
        this.relocatedSection = relocatedSection;
        this.sectionOffset = offset;
        if (requestedLength != 8 && requestedLength != 4 && requestedLength != 2 && requestedLength != 1) {
            throw new IllegalArgumentException("Mach-O cannot represent relocation lengths other than {1,2,4,8} bytes");
        }
        this.log2length = (byte)(requestedLength == 8 ? 3 : (requestedLength == 4 ? 2 : (requestedLength == 2 ? 1 : 0)));
        this.kind = kind;
        MachOSymtab symtab = relocatedSection.getOwner().getSymbolTable();
        this.sym = symtab.getSymbol(symbolName);
        assert (!asLocalReloc || this.sym.isDefined());
        this.targetSection = asLocalReloc ? (MachOObjectFile.MachOSection)this.sym.getDefinedSection() : null;
        this.addend = addend;
    }

    static MachORelocationInfo createARM64RelocAddend(MachORelocationElement containingElement, MachOObjectFile.MachOSection relocatedSection, int offset, String symbolName, long addend) {
        int length = 4;
        return new MachORelocationInfo(containingElement, relocatedSection, offset, length, ARM64Reloc.ADDEND, symbolName, false, Math.toIntExact(addend));
    }

    static MachORelocationInfo createRelocation(MachORelocationElement containingElement, MachOObjectFile.MachOSection relocatedSection, int offset, ObjectFile.RelocationKind kind, String symbolName) {
        int length = ObjectFile.RelocationKind.getRelocationSize(kind);
        MachORelocationType type = MachORelocationInfo.getMachORelocationType(relocatedSection, kind);
        return new MachORelocationInfo(containingElement, relocatedSection, offset, length, type, symbolName, false, 0);
    }

    public static int getEncodedSize() {
        return 8;
    }

    public void write(OutputAssembler oa, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
        int symbolNum;
        if (this.isAddendKind()) {
            assert (!this.isExtern()) : "addend must be encoded as a local";
            GraalError.guarantee((boolean)NumUtil.isSignedNbit((int)24, (int)this.addend), (String)"Addend has to be 24bit signed number. Got value 0x%x", (Object)this.addend);
            symbolNum = this.addend;
        } else if (this.isExtern()) {
            symbolNum = this.relocatedSection.getOwner().getSymbolTable().indexOf(this.sym);
        } else {
            symbolNum = this.relocatedSection.getOwner().getSections().indexOf(this.sym.getDefinedSection());
            assert (this.sym.getDefinedOffset() == 0L) : "Relocation for non-external symbol with section base offset != 0 not supported";
        }
        if (this.log2length < 0 || this.log2length >= 4) {
            throw new IllegalArgumentException("Length must be in {1,2,4,8} bytes, so log2length must be in [0,3]");
        }
        int startPos = oa.pos();
        oa.write4Byte(this.sectionOffset);
        int remainingWord = 0;
        remainingWord |= symbolNum & 0xFFFFFF;
        remainingWord |= (this.kind.isPCRelative() ? 1 : 0) << 24;
        remainingWord |= (this.log2length & 3) << 25;
        remainingWord |= (this.isExtern() ? 1 : 0) << 27;
        oa.write4Byte(remainingWord |= (this.kind.getValue() & 0xF) << 28);
        assert (oa.pos() - startPos == 8);
    }

    @Override
    public long getOffset() {
        return this.sectionOffset;
    }

    @Override
    public ObjectFile.Symbol getReferencedSymbol() {
        return this.sym;
    }

    public boolean isAddendKind() {
        return this.kind == ARM64Reloc.ADDEND;
    }

    public long getAddend() {
        return this.addend;
    }

    public MachOObjectFile.MachOSection getRelocatedSection() {
        return this.relocatedSection;
    }

    private boolean isExtern() {
        return this.targetSection == null && !this.isAddendKind();
    }

    private static MachORelocationType getMachORelocationType(MachOObjectFile.MachOSection relocatedSection, ObjectFile.RelocationKind kind) {
        switch (relocatedSection.getOwner().cpuType) {
            case X86_64: {
                switch (kind) {
                    case DIRECT_1: 
                    case DIRECT_2: 
                    case DIRECT_4: 
                    case DIRECT_8: {
                        return X86_64Reloc.UNSIGNED;
                    }
                    case PC_RELATIVE_1: 
                    case PC_RELATIVE_2: 
                    case PC_RELATIVE_4: 
                    case PC_RELATIVE_8: {
                        return X86_64Reloc.SIGNED;
                    }
                }
                throw new IllegalArgumentException("Unknown relocation kind: " + kind);
            }
            case ARM64: {
                switch (kind) {
                    case DIRECT_1: 
                    case DIRECT_2: 
                    case DIRECT_4: 
                    case DIRECT_8: {
                        return ARM64Reloc.UNSIGNED;
                    }
                    case AARCH64_R_AARCH64_ADR_PREL_PG_HI21: {
                        return ARM64Reloc.PAGE21;
                    }
                    case AARCH64_R_AARCH64_LDST64_ABS_LO12_NC: 
                    case AARCH64_R_AARCH64_LDST32_ABS_LO12_NC: 
                    case AARCH64_R_AARCH64_LDST16_ABS_LO12_NC: 
                    case AARCH64_R_AARCH64_LDST8_ABS_LO12_NC: 
                    case AARCH64_R_AARCH64_ADD_ABS_LO12_NC: {
                        return ARM64Reloc.PAGEOFF12;
                    }
                }
                throw new IllegalArgumentException("Unknown relocation kind: " + kind);
            }
        }
        throw new IllegalArgumentException("Unknown relocation kind: " + kind);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            MachORelocationInfo other = (MachORelocationInfo)obj;
            return this.sectionOffset == other.sectionOffset && this.log2length == other.log2length && Objects.equals(this.containingElement, other.containingElement) && this.addend == other.addend && Objects.equals(this.getRelocatedSection(), other.getRelocatedSection()) && this.kind == other.kind && Objects.equals(this.sym, other.sym) && Objects.equals(this.targetSection, other.targetSection);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.containingElement, this.relocatedSection, this.kind, this.sectionOffset, this.sym, this.targetSection, this.log2length, this.addend);
    }
}

