/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import com.oracle.objectfile.elf.dwarf.constants.DwarfAttribute;
import com.oracle.objectfile.elf.dwarf.constants.DwarfForm;
import com.oracle.objectfile.elf.dwarf.constants.DwarfHasChildren;
import com.oracle.objectfile.elf.dwarf.constants.DwarfSectionName;
import com.oracle.objectfile.elf.dwarf.constants.DwarfTag;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfAbbrevSectionImpl
extends DwarfSectionImpl {
    public DwarfAbbrevSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections, DwarfSectionName.DW_ABBREV_SECTION, DwarfSectionName.DW_RANGES_SECTION);
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        int pos = 0;
        pos = this.writeAbbrevs(null, null, pos);
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        pos = this.writeAbbrevs(context, buffer, pos);
        assert (pos == size);
    }

    public int writeAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeCompileUnitAbbrevs(context, buffer, pos);
        pos = this.writePrimitiveTypeAbbrev(context, buffer, pos);
        pos = this.writeVoidTypeAbbrev(context, buffer, pos);
        pos = this.writeObjectHeaderAbbrev(context, buffer, pos);
        pos = this.writeNamespaceAbbrev(context, buffer, pos);
        pos = this.writeClassLayoutAbbrevs(context, buffer, pos);
        pos = this.writeClassReferenceAbbrev(context, buffer, pos);
        pos = this.writeMethodDeclarationAbbrevs(context, buffer, pos);
        pos = this.writeFieldDeclarationAbbrevs(context, buffer, pos);
        pos = this.writeClassConstantAbbrev(context, buffer, pos);
        pos = this.writeArrayLayoutAbbrev(context, buffer, pos);
        pos = this.writeArrayReferenceAbbrev(context, buffer, pos);
        pos = this.writeInterfaceLayoutAbbrev(context, buffer, pos);
        pos = this.writeInterfaceReferenceAbbrev(context, buffer, pos);
        pos = this.writeForeignReferenceAbbrev(context, buffer, pos);
        pos = this.writeForeignTypedefAbbrev(context, buffer, pos);
        pos = this.writeForeignStructAbbrev(context, buffer, pos);
        pos = this.writeHeaderFieldAbbrev(context, buffer, pos);
        pos = this.writeArrayDataTypeAbbrevs(context, buffer, pos);
        pos = this.writeArraySubrangeTypeAbbrev(context, buffer, pos);
        pos = this.writeMethodLocationAbbrev(context, buffer, pos);
        pos = this.writeAbstractInlineMethodAbbrev(context, buffer, pos);
        pos = this.writeStaticFieldLocationAbbrev(context, buffer, pos);
        pos = this.writeSuperReferenceAbbrev(context, buffer, pos);
        pos = this.writeInterfaceImplementorAbbrev(context, buffer, pos);
        pos = this.writeInlinedSubroutineAbbrev(buffer, pos, false);
        pos = this.writeInlinedSubroutineAbbrev(buffer, pos, true);
        if (this.dwarfSections.useHeapBase()) {
            pos = this.writeIndirectLayoutAbbrev(context, buffer, pos);
            pos = this.writeIndirectReferenceAbbrev(context, buffer, pos);
        }
        pos = this.writeParameterDeclarationAbbrevs(context, buffer, pos);
        pos = this.writeLocalDeclarationAbbrevs(context, buffer, pos);
        pos = this.writeParameterLocationAbbrevs(context, buffer, pos);
        pos = this.writeLocalLocationAbbrevs(context, buffer, pos);
        pos = this.writeNullAbbrev(context, buffer, pos);
        return pos;
    }

    private int writeAttrType(DwarfAttribute attribute, byte[] buffer, int pos) {
        return this.writeULEB(attribute.value(), buffer, pos);
    }

    private int writeAttrForm(DwarfForm dwarfForm, byte[] buffer, int pos) {
        return this.writeULEB(dwarfForm.value(), buffer, pos);
    }

    private int writeHasChildren(DwarfHasChildren hasChildren, byte[] buffer, int pos) {
        return this.writeByte(hasChildren.value(), buffer, pos);
    }

    private int writeCompileUnitAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeCompileUnitAbbrev(context, DwarfDebugInfo.AbbrevCode.BUILTIN_UNIT, buffer, pos);
        pos = this.writeCompileUnitAbbrev(context, DwarfDebugInfo.AbbrevCode.CLASS_UNIT_1, buffer, pos);
        pos = this.writeCompileUnitAbbrev(context, DwarfDebugInfo.AbbrevCode.CLASS_UNIT_2, buffer, pos);
        return pos;
    }

    private int writeCompileUnitAbbrev(DebugContext context, DwarfDebugInfo.AbbrevCode abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_compile_unit, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_language, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_use_UTF8, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_comp_dir, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.CLASS_UNIT_2) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_ranges, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_sec_offset, buffer, pos);
            pos = this.writeAttrType(DwarfAttribute.DW_AT_low_pc, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_addr, buffer, pos);
            pos = this.writeAttrType(DwarfAttribute.DW_AT_stmt_list, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_sec_offset, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writePrimitiveTypeAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.PRIMITIVE_TYPE, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_base_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_bit_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_encoding, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeVoidTypeAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.VOID_TYPE, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_unspecified_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeObjectHeaderAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.OBJECT_HEADER, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_structure_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeNamespaceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.NAMESPACE, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_namespace, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeClassLayoutAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeClassLayoutAbbrev(context, DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_1, buffer, pos);
        if (!this.dwarfSections.useHeapBase()) {
            pos = this.writeClassLayoutAbbrev(context, DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_2, buffer, pos);
        }
        return pos;
    }

    private int writeClassLayoutAbbrev(DebugContext context, DwarfDebugInfo.AbbrevCode abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_class_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_decl_file, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_2) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_data_location, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_expr_loc, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeClassReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.CLASS_POINTER, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_pointer_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeMethodDeclarationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeMethodDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_DECLARATION, buffer, pos);
        pos = this.writeMethodDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_DECLARATION_STATIC, buffer, pos);
        return pos;
    }

    private int writeMethodDeclarationAbbrev(DebugContext context, DwarfDebugInfo.AbbrevCode abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_subprogram, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_external, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_decl_file, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_decl_line, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_linkage_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_artificial, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_accessibility, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_declaration, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_containing_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_DECLARATION) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_object_pointer, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeFieldDeclarationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeFieldDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_1, buffer, pos);
        pos = this.writeFieldDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_2, buffer, pos);
        pos = this.writeFieldDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_3, buffer, pos);
        pos = this.writeFieldDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_4, buffer, pos);
        return pos;
    }

    private int writeFieldDeclarationAbbrev(DebugContext context, DwarfDebugInfo.AbbrevCode abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_member, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_2 || abbrevCode == DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_4) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_decl_file, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_1 || abbrevCode == DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_2) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_data_member_location, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_accessibility, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_3 || abbrevCode == DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_4) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_external, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
            pos = this.writeAttrType(DwarfAttribute.DW_AT_declaration, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeClassConstantAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.CLASS_CONSTANT, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_constant, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_accessibility, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_external, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_declaration, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_location, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_expr_loc, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeArrayLayoutAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.ARRAY_LAYOUT, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_class_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeArrayReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.ARRAY_POINTER, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_pointer_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeInterfaceLayoutAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.INTERFACE_LAYOUT, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_union_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeInterfaceReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.INTERFACE_POINTER, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_pointer_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeInterfaceImplementorAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.INTERFACE_IMPLEMENTOR, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_member, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_accessibility, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeForeignReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.FOREIGN_POINTER, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_pointer_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeForeignTypedefAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.FOREIGN_TYPEDEF, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_typedef, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeForeignStructAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.FOREIGN_STRUCT, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_structure_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeHeaderFieldAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.HEADER_FIELD, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_member, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_data_member_location, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_accessibility, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeArrayDataTypeAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeArrayDataTypeAbbrev(context, DwarfDebugInfo.AbbrevCode.ARRAY_DATA_TYPE_1, buffer, pos);
        pos = this.writeArrayDataTypeAbbrev(context, DwarfDebugInfo.AbbrevCode.ARRAY_DATA_TYPE_2, buffer, pos);
        return pos;
    }

    private int writeArrayDataTypeAbbrev(DebugContext context, DwarfDebugInfo.AbbrevCode abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_array_type, buffer, pos);
        boolean hasChildren = abbrevCode == DwarfDebugInfo.AbbrevCode.ARRAY_DATA_TYPE_2;
        pos = this.writeHasChildren(hasChildren ? DwarfHasChildren.DW_CHILDREN_yes : DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.ARRAY_DATA_TYPE_2) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_data4, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeArraySubrangeTypeAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.ARRAY_SUBRANGE, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_subrange_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_count, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeMethodLocationAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.METHOD_LOCATION, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_subprogram, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_low_pc, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_hi_pc, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_external, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_specification, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeAbstractInlineMethodAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.ABSTRACT_INLINE_METHOD, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_subprogram, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_inline, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_external, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_specification, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeStaticFieldLocationAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.STATIC_FIELD_LOCATION, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_variable, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_specification, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_location, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_expr_loc, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeSuperReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.SUPER_REFERENCE, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_inheritance, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_data_member_location, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_accessibility, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeIndirectLayoutAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.INDIRECT_LAYOUT, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_class_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_yes, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_data_location, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_expr_loc, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeIndirectReferenceAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.INDIRECT_POINTER, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_pointer_type, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_byte_size, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data1, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeParameterDeclarationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeParameterDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_1, buffer, pos);
        pos = this.writeParameterDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_2, buffer, pos);
        pos = this.writeParameterDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_3, buffer, pos);
        return pos;
    }

    private int writeParameterDeclarationAbbrev(DebugContext context, DwarfDebugInfo.AbbrevCode abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_formal_parameter, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_2) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_decl_file, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
            pos = this.writeAttrType(DwarfAttribute.DW_AT_decl_line, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_1) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_artificial, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_declaration, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeLocalDeclarationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeLocalDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_DECLARATION_1, buffer, pos);
        pos = this.writeLocalDeclarationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_DECLARATION_2, buffer, pos);
        return pos;
    }

    private int writeLocalDeclarationAbbrev(DebugContext context, DwarfDebugInfo.AbbrevCode abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_variable, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_name, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_strp, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_DECLARATION_1) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_decl_file, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
            pos = this.writeAttrType(DwarfAttribute.DW_AT_decl_line, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_data2, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_type, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_declaration, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_flag, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeParameterLocationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeParameterLocationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_LOCATION_1, buffer, pos);
        pos = this.writeParameterLocationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_LOCATION_2, buffer, pos);
        return pos;
    }

    private int writeLocalLocationAbbrevs(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeLocalLocationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_LOCATION_1, buffer, pos);
        pos = this.writeLocalLocationAbbrev(context, DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_LOCATION_2, buffer, pos);
        return pos;
    }

    private int writeParameterLocationAbbrev(DebugContext context, DwarfDebugInfo.AbbrevCode abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_formal_parameter, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_abstract_origin, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_LOCATION_2) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_location, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_sec_offset, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeLocalLocationAbbrev(DebugContext context, DwarfDebugInfo.AbbrevCode abbrevCode, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_variable, buffer, pos);
        pos = this.writeHasChildren(DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_abstract_origin, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_LOCATION_2) {
            pos = this.writeAttrType(DwarfAttribute.DW_AT_location, buffer, pos);
            pos = this.writeAttrForm(DwarfForm.DW_FORM_sec_offset, buffer, pos);
        }
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }

    private int writeNullAbbrev(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeAbbrevCode(DwarfDebugInfo.AbbrevCode.NULL, buffer, pos);
        return pos;
    }

    private int writeInlinedSubroutineAbbrev(byte[] buffer, int p, boolean withChildren) {
        int pos = p;
        pos = this.writeAbbrevCode(withChildren ? DwarfDebugInfo.AbbrevCode.INLINED_SUBROUTINE_WITH_CHILDREN : DwarfDebugInfo.AbbrevCode.INLINED_SUBROUTINE, buffer, pos);
        pos = this.writeTag(DwarfTag.DW_TAG_inlined_subroutine, buffer, pos);
        pos = this.writeHasChildren(withChildren ? DwarfHasChildren.DW_CHILDREN_yes : DwarfHasChildren.DW_CHILDREN_no, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_abstract_origin, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_ref4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_low_pc, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_hi_pc, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_addr, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_call_file, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_call_line, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_data4, buffer, pos);
        pos = this.writeAttrType(DwarfAttribute.DW_AT_null, buffer, pos);
        pos = this.writeAttrForm(DwarfForm.DW_FORM_null, buffer, pos);
        return pos;
    }
}

