/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.elf.ELFAArch64Relocation;
import com.oracle.objectfile.elf.ELFRISCV64Relocation;
import com.oracle.objectfile.elf.ELFRelocationSection;
import com.oracle.objectfile.elf.ELFX86_64Relocation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ELFMachine {
    X86_64{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return ELFX86_64Relocation.class;
        }

        @Override
        int flags() {
            return 0;
        }
    }
    ,
    AArch64{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return ELFAArch64Relocation.class;
        }

        @Override
        int flags() {
            return 0;
        }
    }
    ,
    RISCV64{

        @Override
        Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes() {
            return ELFRISCV64Relocation.class;
        }

        @Override
        int flags() {
            return 5;
        }
    };

    private static final int NO_FLAGS = 0;
    private static final int RVC_DOUBLE_FLOAT_ABI = 5;

    abstract Class<? extends Enum<? extends ObjectFile.RelocationMethod>> relocationTypes();

    abstract int flags();

    public static ELFMachine from(String s) {
        switch (s.toLowerCase()) {
            case "amd64": 
            case "x86_64": {
                return X86_64;
            }
            case "arm64": 
            case "aarch64": {
                return AArch64;
            }
            case "riscv64": {
                return RISCV64;
            }
        }
        throw new IllegalStateException("Unknown CPU type: " + s);
    }

    public static ELFRelocationSection.ELFRelocationMethod getRelocation(ELFMachine m, ObjectFile.RelocationKind k) {
        switch (m) {
            case X86_64: {
                switch (k) {
                    case DIRECT_1: {
                        return ELFX86_64Relocation.R_8;
                    }
                    case DIRECT_2: {
                        return ELFX86_64Relocation.R_16;
                    }
                    case DIRECT_4: {
                        return ELFX86_64Relocation.R_32;
                    }
                    case DIRECT_8: {
                        return ELFX86_64Relocation.R_64;
                    }
                    case PC_RELATIVE_1: {
                        return ELFX86_64Relocation.R_PC8;
                    }
                    case PC_RELATIVE_2: {
                        return ELFX86_64Relocation.R_PC16;
                    }
                    case PC_RELATIVE_4: {
                        return ELFX86_64Relocation.R_PC32;
                    }
                    case PC_RELATIVE_8: {
                        return ELFX86_64Relocation.R_PC64;
                    }
                }
                throw new IllegalArgumentException("Cannot map unknown relocation kind to an ELF x86-64 relocation type");
            }
            case AArch64: {
                switch (k) {
                    case DIRECT_2: {
                        return ELFAArch64Relocation.R_AARCH64_ABS16;
                    }
                    case DIRECT_4: {
                        return ELFAArch64Relocation.R_AARCH64_ABS32;
                    }
                    case DIRECT_8: {
                        return ELFAArch64Relocation.R_AARCH64_ABS64;
                    }
                    case AARCH64_R_MOVW_UABS_G0: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G0;
                    }
                    case AARCH64_R_MOVW_UABS_G0_NC: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G0_NC;
                    }
                    case AARCH64_R_MOVW_UABS_G1: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G1;
                    }
                    case AARCH64_R_MOVW_UABS_G1_NC: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G1_NC;
                    }
                    case AARCH64_R_MOVW_UABS_G2: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G2;
                    }
                    case AARCH64_R_MOVW_UABS_G2_NC: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G2_NC;
                    }
                    case AARCH64_R_MOVW_UABS_G3: {
                        return ELFAArch64Relocation.R_AARCH64_MOVW_UABS_G3;
                    }
                    case AARCH64_R_AARCH64_ADR_PREL_PG_HI21: {
                        return ELFAArch64Relocation.R_AARCH64_ADR_PREL_PG_HI21;
                    }
                    case AARCH64_R_AARCH64_ADD_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_ADD_ABS_LO12_NC;
                    }
                    case AARCH64_R_GOT_LD_PREL19: {
                        return ELFAArch64Relocation.R_AARCH64_GOT_LD_PREL19;
                    }
                    case AARCH64_R_LD_PREL_LO19: {
                        return ELFAArch64Relocation.R_AARCH64_LD_PREL_LO19;
                    }
                    case AARCH64_R_AARCH64_LDST128_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_LDST128_ABS_LO12_NC;
                    }
                    case AARCH64_R_AARCH64_LDST64_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_LDST64_ABS_LO12_NC;
                    }
                    case AARCH64_R_AARCH64_LDST32_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_LDST32_ABS_LO12_NC;
                    }
                    case AARCH64_R_AARCH64_LDST16_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_LDST16_ABS_LO12_NC;
                    }
                    case AARCH64_R_AARCH64_LDST8_ABS_LO12_NC: {
                        return ELFAArch64Relocation.R_AARCH64_LDST8_ABS_LO12_NC;
                    }
                }
                throw new IllegalArgumentException("Cannot map unknown relocation kind to an ELF aarch64 relocation type: " + k);
            }
            case RISCV64: {
                switch (k) {
                    case DIRECT_8: {
                        return ELFRISCV64Relocation.R_RISCV_64;
                    }
                }
                throw new IllegalArgumentException("Cannot map unknown relocation kind to an ELF riscv64 relocation type: " + k);
            }
        }
        throw new IllegalStateException("Unknown ELF machine type");
    }

    public static ELFMachine from(int m) {
        switch (m) {
            case 62: {
                return X86_64;
            }
            case 183: {
                return AArch64;
            }
            case 243: {
                return RISCV64;
            }
        }
        throw new IllegalStateException("Unknown ELF machine type");
    }

    public short toShort() {
        if (this == AArch64) {
            return 183;
        }
        if (this == X86_64) {
            return 62;
        }
        if (this == RISCV64) {
            return 243;
        }
        throw new IllegalStateException("Should not reach here");
    }

    public static ELFMachine getSystemNativeValue() {
        String arch;
        return switch (arch = System.getProperty("os.arch")) {
            case "aarch64", "arm64" -> AArch64;
            case "amd64", "x86_64" -> X86_64;
            case "riscv64" -> RISCV64;
            default -> throw new IllegalArgumentException("Unsupported ELF machine type: " + arch);
        };
    }
}

