/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.ImageSingletons;

public class ImageBuildStatistics {
    final TreeMap<String, AtomicLong> counters = new TreeMap();

    public AtomicLong insert(String key) {
        AtomicLong result = new AtomicLong();
        AtomicLong existing = this.counters.put(key, result);
        if (existing != null) {
            throw GraalError.shouldNotReachHere((String)("Key already used: " + key));
        }
        return result;
    }

    public void incDevirtualizedInvokeCounter() {
        this.counters.get(ImageBuildStatistics.devirtualizedInvokes()).incrementAndGet();
    }

    public void incByteCodeException(BytecodeExceptionNode.BytecodeExceptionKind kind, CheckCountLocation location) {
        this.counters.get(ImageBuildStatistics.getName(kind.name(), location)).incrementAndGet();
    }

    public Consumer<PrintWriter> getReporter() {
        ImageBuildCountersReport printer = new ImageBuildCountersReport();
        return printer::print;
    }

    private static String getName(String name, CheckCountLocation location) {
        return ("total_" + name + "_" + location.name()).toLowerCase(Locale.ROOT);
    }

    private static String devirtualizedInvokes() {
        return "total_devirtualized_invokes";
    }

    public static ImageBuildStatistics counters() {
        return (ImageBuildStatistics)ImageSingletons.lookup(ImageBuildStatistics.class);
    }

    public ImageBuildStatistics() {
        this.counters.put(ImageBuildStatistics.devirtualizedInvokes(), new AtomicLong());
        for (BytecodeExceptionNode.BytecodeExceptionKind kind : BytecodeExceptionNode.BytecodeExceptionKind.values()) {
            for (CheckCountLocation location : CheckCountLocation.values()) {
                this.counters.put(ImageBuildStatistics.getName(kind.name(), location), new AtomicLong());
            }
        }
    }

    public static enum CheckCountLocation {
        BEFORE_STRENGTHEN_GRAPHS,
        AFTER_STRENGTHEN_GRAPHS,
        AFTER_PARSE_CANONICALIZATION,
        BEFORE_HIGH_TIER,
        AFTER_HIGH_TIER;

    }

    class ImageBuildCountersReport {
        static final String INDENT = "   ";

        ImageBuildCountersReport() {
        }

        void print(PrintWriter out) {
            StringBuilder json = new StringBuilder();
            json.append("{").append(System.lineSeparator());
            for (Map.Entry<String, AtomicLong> entry : ImageBuildStatistics.this.counters.entrySet()) {
                json.append("   \"").append(entry.getKey()).append("\":").append(entry.getValue().get()).append(",").append(System.lineSeparator());
            }
            out.print(json);
            this.printTimerStats(out);
            out.format("}%n", new Object[0]);
        }

        private void printTimerStats(PrintWriter out) {
            TimerCollectionPrinter dumper = (TimerCollectionPrinter)ImageSingletons.lookup(TimerCollectionPrinter.class);
            dumper.printTimerStats(out);
        }
    }

    public static interface TimerCollectionPrinter {
        public void printTimerStats(PrintWriter var1);
    }

    public static class Options {
        public static final OptionKey<Boolean> CollectImageBuildStatistics = new OptionKey((Object)false);
    }
}

