/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.json.internal;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Providers;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.eclipse.persistence.jaxb.ObjectGraph;
import org.glassfish.jersey.message.filtering.spi.ObjectProvider;
import org.glassfish.jersey.moxy.json.internal.ConfigurableMoxyJsonProvider;

@Singleton
public class FilteringMoxyJsonProvider
extends ConfigurableMoxyJsonProvider {
    private final Provider<ObjectProvider<ObjectGraph>> provider;

    @Inject
    public FilteringMoxyJsonProvider(@Context Provider<ObjectProvider<ObjectGraph>> provider, @Context Providers providers, @Context Configuration config) {
        super(providers, config);
        this.provider = provider;
    }

    @Override
    protected void preWriteTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, Marshaller marshaller) throws JAXBException {
        Object objectGraph;
        super.preWriteTo(object, type, genericType, annotations, mediaType, httpHeaders, marshaller);
        if (marshaller.getProperty("eclipselink.object-graph") == null && (objectGraph = ((ObjectProvider)this.provider.get()).getFilteringObject(genericType, true, annotations)) != null) {
            marshaller.setProperty("eclipselink.object-graph", objectGraph);
        }
    }

    @Override
    protected void preReadFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, Unmarshaller unmarshaller) throws JAXBException {
        Object objectGraph;
        super.preReadFrom(type, genericType, annotations, mediaType, httpHeaders, unmarshaller);
        if (unmarshaller.getProperty("eclipselink.object-graph") == null && (objectGraph = ((ObjectProvider)this.provider.get()).getFilteringObject(genericType, false, annotations)) != null) {
            unmarshaller.setProperty("eclipselink.object-graph", objectGraph);
        }
    }
}

