/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.push;

import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.push.WebsocketUserManager;
import com.sun.faces.util.Json;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.context.FacesContext;
import javax.faces.event.WebsocketEvent;
import javax.inject.Inject;
import javax.websocket.CloseReason;
import javax.websocket.Session;

@ApplicationScoped
public class WebsocketSessionManager {
    private static final CloseReason REASON_EXPIRED = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Expired");
    private static final AnnotationLiteral<WebsocketEvent.Opened> SESSION_OPENED = new AnnotationLiteral<WebsocketEvent.Opened>(){
        private static final long serialVersionUID = 1L;
    };
    private static final AnnotationLiteral<WebsocketEvent.Closed> SESSION_CLOSED = new AnnotationLiteral<WebsocketEvent.Closed>(){
        private static final long serialVersionUID = 1L;
    };
    private final ConcurrentMap<String, Set<Session>> socketSessions = new ConcurrentHashMap<String, Set<Session>>();
    @Inject
    private WebsocketUserManager socketUsers;
    private static volatile WebsocketSessionManager instance;

    protected void register(String channelId) {
        if (!this.socketSessions.containsKey(channelId)) {
            this.socketSessions.putIfAbsent(channelId, Collections.synchronizedSet(new HashSet()));
        }
    }

    protected void register(Iterable<String> channelIds) {
        for (String channelId : channelIds) {
            this.register(channelId);
        }
    }

    protected boolean add(Session session) {
        String channelId = WebsocketSessionManager.getChannelId(session);
        Set sessions = (Set)this.socketSessions.get(channelId);
        if (sessions != null && sessions.add(session)) {
            Serializable user = this.socketUsers.getUser(WebsocketSessionManager.getChannel(session), channelId);
            if (user != null) {
                session.getUserProperties().put("user", user);
            }
            WebsocketSessionManager.fireEvent(session, null, SESSION_OPENED);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Future<Void>> send(String channelId, Object message) {
        Set sessions;
        Set set = sessions = channelId != null ? (Set)this.socketSessions.get(channelId) : null;
        if (sessions != null && !sessions.isEmpty()) {
            HashSet<Future<Void>> results = new HashSet<Future<Void>>(sessions.size());
            String json = Json.encode(message, new Json.Option[0]);
            Set set2 = sessions;
            synchronized (set2) {
                for (Session session : sessions) {
                    if (!session.isOpen()) continue;
                    results.add(session.getAsyncRemote().sendText(json));
                }
            }
            return results;
        }
        return Collections.emptySet();
    }

    protected void remove(Session session, CloseReason reason) {
        Set sessions = (Set)this.socketSessions.get(WebsocketSessionManager.getChannelId(session));
        if (sessions != null && sessions.remove(session)) {
            WebsocketSessionManager.fireEvent(session, reason, SESSION_CLOSED);
        }
    }

    protected void deregister(Iterable<String> channelIds) {
        for (String channelId : channelIds) {
            Set sessions = (Set)this.socketSessions.get(channelId);
            if (sessions == null) continue;
            for (Session session : sessions) {
                if (!session.isOpen()) continue;
                try {
                    session.close(REASON_EXPIRED);
                }
                catch (IOException ignore) {}
            }
        }
    }

    static WebsocketSessionManager getInstance() {
        if (instance == null) {
            instance = CdiUtils.getBeanReference(WebsocketSessionManager.class, new Annotation[0]);
        }
        return instance;
    }

    private static String getChannel(Session session) {
        return (String)session.getPathParameters().get("channel");
    }

    private static String getChannelId(Session session) {
        return WebsocketSessionManager.getChannel(session) + "?" + session.getQueryString();
    }

    private static void fireEvent(Session session, CloseReason reason, AnnotationLiteral<?> qualifier) {
        Serializable user = (Serializable)session.getUserProperties().get("user");
        Util.getCdiBeanManager(FacesContext.getCurrentInstance()).fireEvent((Object)new WebsocketEvent(WebsocketSessionManager.getChannel(session), user, reason != null ? reason.getCloseCode() : null), new Annotation[]{qualifier});
    }
}

