/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.push;

import com.sun.faces.renderkit.RenderKitUtils;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

public class WebsocketFacesListener
implements SystemEventListener {
    private static final String SCRIPT_INIT = "jsf.push.init(%s,'%s',%s,%s);";
    private static final String SCRIPT_OPEN = "jsf.push.open('%s');";
    private static final String SCRIPT_CLOSE = "jsf.push.close('%s');";
    private Integer port;
    private String channel;
    private String uri;
    private String functions;
    private ValueExpression connectedExpression;

    public WebsocketFacesListener(Integer port, String channel, String uri, String functions, ValueExpression connectedExpression) {
        this.port = port;
        this.channel = channel;
        this.uri = uri;
        this.functions = functions;
        this.connectedExpression = connectedExpression;
    }

    @Override
    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    @Override
    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (event instanceof PostAddToViewEvent) {
            RenderKitUtils.installJsfJsIfNecessary(context);
        } else if (event instanceof PreRenderViewEvent) {
            boolean connected = this.connectedExpression == null || Boolean.TRUE.equals(this.connectedExpression.getValue(context.getELContext()));
            Boolean switched = WebsocketFacesListener.hasSwitched(context, this.channel, connected);
            String script = null;
            if (switched == null) {
                script = String.format(SCRIPT_INIT, this.port, this.uri, this.functions, connected);
            } else if (switched.booleanValue()) {
                script = String.format(connected ? SCRIPT_OPEN : SCRIPT_CLOSE, this.channel);
            }
            if (script != null) {
                PartialViewContext pvc = context.getPartialViewContext();
                if (pvc.isAjaxRequest() && !pvc.isRenderAll()) {
                    context.getPartialViewContext().getEvalScripts().add(script);
                } else {
                    UIOutput outputScript = new UIOutput();
                    outputScript.setRendererType("javax.faces.resource.Script");
                    UIOutput content = new UIOutput();
                    content.setValue(script);
                    outputScript.getChildren().add(content);
                    context.getViewRoot().addComponentResource(context, outputScript, "body");
                }
            }
        }
    }

    private static Boolean hasSwitched(FacesContext context, String channel, boolean connected) {
        Boolean previouslyConnected;
        Map<String, Object> viewScope = context.getViewRoot().getViewMap();
        HashMap<String, Boolean> channels = (HashMap<String, Boolean>)viewScope.get(WebsocketFacesListener.class.getName());
        if (channels == null) {
            channels = new HashMap<String, Boolean>();
            viewScope.put(WebsocketFacesListener.class.getName(), channels);
        }
        return (previouslyConnected = channels.put(channel, connected)) == null ? null : Boolean.valueOf(previouslyConnected != connected);
    }
}

