/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.push;

import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.push.WebsocketSessionManager;
import com.sun.faces.push.WebsocketUserManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;

@SessionScoped
public class WebsocketChannelManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_INVALID_SCOPE = "f:websocket 'scope' attribute '%s' does not represent a valid scope. It may not be an EL expression and allowed values are 'application', 'session' and 'view', case insensitive. The default is 'application'. When 'user' attribute is specified, then scope defaults to 'session' and may not be 'application'.";
    private static final String ERROR_DUPLICATE_CHANNEL = "f:websocket channel '%s' is already registered on a different scope. Choose an unique channel name for a different channel (or shutdown all browsers and restart the server if you were just testing).";
    private static final int ESTIMATED_CHANNELS_PER_APPLICATION = 1;
    private static final int ESTIMATED_CHANNELS_PER_SESSION = 1;
    private static final int ESTIMATED_CHANNELS_PER_VIEW = 1;
    private static final int ESTIMATED_USERS_PER_SESSION = 1;
    static final int ESTIMATED_TOTAL_CHANNELS = 3;
    static final Map<String, String> EMPTY_SCOPE = Collections.emptyMap();
    private static final ConcurrentMap<String, String> APPLICATION_SCOPE = new ConcurrentHashMap<String, String>(1);
    private final ConcurrentMap<String, String> sessionScope = new ConcurrentHashMap<String, String>(1);
    private final ConcurrentMap<Serializable, String> sessionUsers = new ConcurrentHashMap<Serializable, String>(1);
    @Inject
    private WebsocketSessionManager socketSessions;
    @Inject
    private WebsocketUserManager socketUsers;

    public String register(String channel, String scope, Serializable user) {
        switch (Scope.of(scope, user)) {
            case APPLICATION: {
                return this.register(null, channel, APPLICATION_SCOPE, this.sessionScope, WebsocketChannelManager.getViewScope(false));
            }
            case SESSION: {
                return this.register(user, channel, this.sessionScope, APPLICATION_SCOPE, WebsocketChannelManager.getViewScope(false));
            }
            case VIEW: {
                return this.register(user, channel, WebsocketChannelManager.getViewScope(true), APPLICATION_SCOPE, this.sessionScope);
            }
        }
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    private final String register(Serializable user, String channel, Map<String, String> targetScope, Map<String, String> ... otherScopes) {
        if (!targetScope.containsKey(channel)) {
            for (Map<String, String> otherScope : otherScopes) {
                if (!otherScope.containsKey(channel)) continue;
                throw new IllegalArgumentException(String.format(ERROR_DUPLICATE_CHANNEL, channel));
            }
            ((ConcurrentMap)targetScope).putIfAbsent(channel, channel + "?" + UUID.randomUUID().toString());
        }
        String channelId = targetScope.get(channel);
        if (user != null) {
            if (!this.sessionUsers.containsKey(user)) {
                this.sessionUsers.putIfAbsent(user, UUID.randomUUID().toString());
                this.socketUsers.register(user, (String)this.sessionUsers.get(user));
            }
            this.socketUsers.addChannelId((String)this.sessionUsers.get(user), channel, channelId);
        }
        this.socketSessions.register(channelId);
        return channelId;
    }

    @PreDestroy
    protected void deregisterSessionScope() {
        for (Map.Entry sessionUser : this.sessionUsers.entrySet()) {
            this.socketUsers.deregister((Serializable)sessionUser.getKey(), (String)sessionUser.getValue());
        }
        this.socketSessions.deregister(this.sessionScope.values());
    }

    static Map<String, String> getSessionScope() {
        return CdiUtils.getBeanInstance(WebsocketChannelManager.class, (boolean)true).sessionScope;
    }

    static Map<String, String> getViewScope(boolean create) {
        ViewScope bean = CdiUtils.getBeanInstance(ViewScope.class, create);
        return bean == null ? EMPTY_SCOPE : bean.viewScope;
    }

    static String getChannelId(String channel, Map<String, String> sessionScope, Map<String, String> viewScope) {
        String channelId = viewScope.get(channel);
        if (channelId == null && (channelId = sessionScope.get(channel)) == null) {
            channelId = (String)APPLICATION_SCOPE.get(channel);
        }
        return channelId;
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeObject(APPLICATION_SCOPE);
        HashMap sessionUserChannels = new HashMap(this.sessionUsers.size());
        for (String userId : this.sessionUsers.values()) {
            sessionUserChannels.put(userId, WebsocketUserManager.getUserChannels().get(userId));
        }
        output.writeObject(sessionUserChannels);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        APPLICATION_SCOPE.putAll((Map)input.readObject());
        Map sessionUserChannels = (Map)input.readObject();
        for (Map.Entry sessionUser : this.sessionUsers.entrySet()) {
            String userId = (String)sessionUser.getValue();
            this.socketUsers.register((Serializable)sessionUser.getKey(), userId);
            WebsocketUserManager.getUserChannels().put(userId, (ConcurrentMap<String, Set<String>>)sessionUserChannels.get(userId));
        }
        this.socketSessions.register(this.sessionScope.values());
        this.socketSessions.register(APPLICATION_SCOPE.values());
    }

    @ViewScoped
    public static class ViewScope
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ConcurrentMap<String, String> viewScope = new ConcurrentHashMap<String, String>(1);

        @PreDestroy
        protected void deregisterViewScope() {
            WebsocketSessionManager.getInstance().deregister(this.viewScope.values());
        }
    }

    private static enum Scope {
        APPLICATION,
        SESSION,
        VIEW;


        static Scope of(String value, Serializable user) {
            if (value == null) {
                return user == null ? APPLICATION : SESSION;
            }
            for (Scope scope : Scope.values()) {
                if (!scope.name().equalsIgnoreCase(value) || user != null && scope == APPLICATION) continue;
                return scope;
            }
            throw new IllegalArgumentException(String.format(WebsocketChannelManager.ERROR_INVALID_SCOPE, value));
        }
    }
}

