/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.push.WebsocketChannelManager;
import com.sun.faces.push.WebsocketFacesListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;

public class WebsocketHandler
extends TagHandlerImpl {
    private static final Pattern PATTERN_CHANNEL_NAME = Pattern.compile("[\\w.-]+");
    private static final String ERROR_ENDPOINT_NOT_ENABLED = "f:websocket endpoint is not enabled. You need to set web.xml context param 'javax.faces.ENABLE_WEBSOCKET_ENDPOINT' with value 'true'.";
    private static final String ERROR_INVALID_CHANNEL = "f:websocket 'channel' attribute '%s' does not represent a valid channel name. It may not be an EL expression and it may only contain alphanumeric characters, hyphens, underscores and periods.";
    private static final String ERROR_INVALID_USER = "f:websocket 'user' attribute '%s' does not represent a valid user identifier. It must implement Serializable and preferably have low memory footprint. Suggestion: use #{request.remoteUser} or #{someLoggedInUser.id}.";
    private final TagAttribute port = this.getAttribute("port");
    private final TagAttribute channel = this.getRequiredAttribute("channel");
    private final TagAttribute scope = this.getAttribute("scope");
    private final TagAttribute user = this.getAttribute("user");
    private final TagAttribute onopen = this.getAttribute("onopen");
    private final TagAttribute onmessage = this.getRequiredAttribute("onmessage");
    private final TagAttribute onclose = this.getAttribute("onclose");
    private final TagAttribute connected = this.getAttribute("connected");

    public WebsocketHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext context, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew(parent)) {
            return;
        }
        if (!WebConfiguration.getInstance().isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableWebsocketEndpoint)) {
            throw new IllegalStateException(ERROR_ENDPOINT_NOT_ENABLED);
        }
        Integer portNumber = this.port != null ? (Integer)this.port.getValueExpression(context, Integer.class).getValue((ELContext)context) : null;
        String channelName = WebsocketHandler.getChannelName(context, this.channel);
        String channelId = WebsocketHandler.getChannelId(context, channelName, this.scope, this.user);
        String onopenFunction = this.onopen != null ? this.onopen.getValue(context) : null;
        String onmessageFunction = this.onmessage.getValue(context);
        String oncloseFunction = this.onclose != null ? this.onclose.getValue(context) : null;
        String functions = onopenFunction + "," + onmessageFunction + "," + oncloseFunction;
        ValueExpression connectedExpression = this.connected != null ? this.connected.getValueExpression(context, Boolean.class) : null;
        WebsocketFacesListener listener = new WebsocketFacesListener(portNumber, channelName, channelId, functions, connectedExpression);
        UIViewRoot view = context.getFacesContext().getViewRoot();
        view.subscribeToViewEvent(PostAddToViewEvent.class, listener);
        view.subscribeToViewEvent(PreRenderViewEvent.class, listener);
    }

    private static String getChannelName(FaceletContext context, TagAttribute channel) {
        String channelName;
        String string = channelName = channel.isLiteral() ? channel.getValue(context) : null;
        if (channelName == null || !PATTERN_CHANNEL_NAME.matcher(channelName).matches()) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_CHANNEL, channelName));
        }
        return channelName;
    }

    private static String getChannelId(FaceletContext context, String channelName, TagAttribute scope, TagAttribute user) {
        Object userObject;
        Object object = userObject = user != null ? user.getObject(context) : null;
        if (userObject != null && !(userObject instanceof Serializable)) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_USER, userObject));
        }
        WebsocketChannelManager socketChannels = CdiUtils.getBeanReference(WebsocketChannelManager.class, new Annotation[0]);
        String scopeName = scope == null ? null : (scope.isLiteral() ? scope.getValue(context) : "");
        return socketChannels.register(channelName, scopeName, (Serializable)userObject);
    }
}

