/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.ext.component;

import com.sun.faces.ext.component.MessageFactory;
import com.sun.faces.ext.component.MultiFieldValidationUtils;
import com.sun.faces.ext.component.UIValidateWholeBean;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.copier.CloneCopier;
import com.sun.faces.util.copier.CopyCtorCopier;
import com.sun.faces.util.copier.NewInstanceCopier;
import com.sun.faces.util.copier.SerializationCopier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;

class WholeBeanValidator
implements javax.faces.validator.Validator {
    private static final Logger LOGGER = Logger.getLogger("javax.faces.validator", "javax.faces.LogStrings");

    WholeBeanValidator() {
    }

    public void validate(FacesContext context, UIComponent c, Object value) throws ValidatorException {
        ValueExpression beanVE = c.getValueExpression("value");
        if (null == beanVE) {
            throw new FacesException("The \"value\" attribute is required");
        }
        Object val = beanVE.getValue(context.getELContext());
        Map<Object, Map<String, Map<String, Object>>> candidates = MultiFieldValidationUtils.getMultiFieldValidationCandidates(context, false);
        if (candidates.isEmpty() || !candidates.containsKey(val)) {
            return;
        }
        Map<String, Map<String, Object>> candidate = candidates.get(val);
        for (Map.Entry<String, Map<String, Object>> cur : candidate.entrySet()) {
            if (!"javax.faces.Bean.FAILED_FIELD_LEVEL_VALIDATION".equals(cur.getValue().get("value"))) continue;
            return;
        }
        Object valCopy = this.copyObjectAndPopulateWithCandidateValues(beanVE, val, candidate);
        Validator beanValidator = this.getBeanValidator(context);
        UIValidateWholeBean component = (UIValidateWholeBean)c;
        Class[] validationGroupArray = component.getValidationGroupsArray();
        Set result = null;
        try {
            result = beanValidator.validate(valCopy, validationGroupArray);
        }
        catch (IllegalArgumentException iae) {
            String failureMessage = "Unable to validate expression " + beanVE.getExpressionString() + " using Bean Validation.  Unable to get value of expression. " + " Message from Bean Validation: " + iae.getMessage();
            LOGGER.fine(failureMessage);
        }
        Set violations = result;
        if (violations != null && !violations.isEmpty()) {
            ValidatorException toThrow;
            if (1 == violations.size()) {
                ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
                toThrow = new ValidatorException(MessageFactory.getMessage(context, "javax.faces.validator.BeanValidator.MESSAGE", violation.getMessage(), MessageFactory.getLabel(context, component)));
            } else {
                LinkedHashSet<FacesMessage> messages = new LinkedHashSet<FacesMessage>(violations.size());
                for (ConstraintViolation violation : violations) {
                    messages.add(MessageFactory.getMessage(context, "javax.faces.validator.BeanValidator.MESSAGE", violation.getMessage(), MessageFactory.getLabel(context, component)));
                }
                toThrow = new ValidatorException(messages);
            }
            for (Map.Entry<String, Map<String, Object>> cur : candidate.entrySet()) {
                ((EditableValueHolder)cur.getValue().get("component")).setValid(false);
            }
            throw toThrow;
        }
    }

    private Object copyObjectAndPopulateWithCandidateValues(ValueExpression beanVE, Object val, Map<String, Map<String, Object>> candidate) {
        HashMap<String, Object> propertiesToSet = new HashMap<String, Object>();
        for (Map.Entry<String, Map<String, Object>> cur : candidate.entrySet()) {
            propertiesToSet.put(cur.getKey(), cur.getValue().get("value"));
        }
        Object valCopy = null;
        try {
            NewInstanceCopier nic = new NewInstanceCopier();
            valCopy = nic.copy(val);
        }
        catch (IllegalStateException nic) {
            // empty catch block
        }
        if (null == valCopy) {
            if (val instanceof Serializable) {
                try {
                    SerializationCopier sc = new SerializationCopier();
                    valCopy = sc.copy(val);
                }
                catch (IllegalStateException sc) {}
            } else if (val instanceof Cloneable) {
                try {
                    CloneCopier cc = new CloneCopier();
                    valCopy = cc.copy(val);
                }
                catch (IllegalStateException cc) {}
            } else {
                try {
                    CopyCtorCopier ccc = new CopyCtorCopier();
                    valCopy = ccc.copy(val);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        if (null == valCopy) {
            throw new FacesException("Unable to copy value from " + beanVE.getExpressionString());
        }
        ReflectionUtils.setProperties(valCopy, propertiesToSet);
        return valCopy;
    }

    private Validator getBeanValidator(FacesContext context) {
        ValidatorFactory validatorFactory;
        Object cachedObject = context.getExternalContext().getApplicationMap().get("javax.faces.validator.beanValidator.ValidatorFactory");
        if (cachedObject instanceof ValidatorFactory) {
            validatorFactory = (ValidatorFactory)cachedObject;
        } else {
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (ValidationException e) {
                throw new FacesException("Could not build a default Bean Validator factory", e);
            }
            context.getExternalContext().getApplicationMap().put("javax.faces.validator.beanValidator.ValidatorFactory", validatorFactory);
        }
        ValidatorContext validatorContext = validatorFactory.usingContext();
        JsfAwareMessageInterpolator jsfMessageInterpolator = new JsfAwareMessageInterpolator(context, validatorFactory.getMessageInterpolator());
        validatorContext.messageInterpolator((MessageInterpolator)jsfMessageInterpolator);
        return validatorContext.getValidator();
    }

    private static class JsfAwareMessageInterpolator
    implements MessageInterpolator {
        private final FacesContext context;
        private final MessageInterpolator delegate;

        public JsfAwareMessageInterpolator(FacesContext context, MessageInterpolator delegate) {
            this.context = context;
            this.delegate = delegate;
        }

        public String interpolate(String message, MessageInterpolator.Context context) {
            Locale locale = this.context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            return this.delegate.interpolate(message, context, locale);
        }

        public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
            return this.delegate.interpolate(message, context, locale);
        }
    }
}

