/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.ext.component;

import com.sun.faces.ext.component.WholeBeanValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import javax.validation.groups.Default;

public class UIValidateWholeBean
extends UIInput
implements PartialStateHolder {
    public static final String FAMILY = "com.sun.faces.ext.validateWholeBean";
    private transient Class[] cachedValidationGroups;
    private transient String validationGroups = "";
    private boolean initialState;
    private boolean transientValue;

    @Override
    public String getFamily() {
        return FAMILY;
    }

    @Override
    public Object getSubmittedValue() {
        return this.getFamily();
    }

    @Override
    public void setConverter(Converter converter) {
    }

    @Override
    public final void addValidator(Validator validator) {
        if (validator instanceof WholeBeanValidator) {
            super.addValidator(validator);
            this.setValidatorInstalled(true);
        }
    }

    public void setValidationGroups(String validationGroups) {
        this.clearInitialState();
        String newValidationGroups = validationGroups;
        if (newValidationGroups != null && newValidationGroups.matches("^[\\W,]*$")) {
            newValidationGroups = null;
        }
        if (newValidationGroups == null && validationGroups != null) {
            this.cachedValidationGroups = null;
        }
        if (newValidationGroups != null && validationGroups != null && !newValidationGroups.equals(validationGroups)) {
            this.cachedValidationGroups = null;
        }
        if (newValidationGroups != null && validationGroups == null) {
            this.cachedValidationGroups = null;
        }
        this.validationGroups = newValidationGroups;
    }

    public String getValidationGroups() {
        return this.validationGroups;
    }

    @Override
    public void validate(FacesContext context) {
        if (!this.wholeBeanValidationEnabled(context)) {
            return;
        }
        if (!this.isValidatorInstalled()) {
            WholeBeanValidator validator = new WholeBeanValidator();
            this.addValidator(validator);
        }
        super.validate(context);
    }

    private boolean isValidatorInstalled() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.ValidatorInstalled), false);
    }

    private void setValidatorInstalled(boolean newValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.ValidatorInstalled), newValue);
    }

    Class[] getValidationGroupsArray() {
        String[] classNames;
        if (this.cachedValidationGroups != null) {
            return this.cachedValidationGroups;
        }
        String validationGroupsStr = this.getValidationGroups();
        ArrayList validationGroupsList = new ArrayList();
        for (String className : classNames = validationGroupsStr.split(",")) {
            if ((className = className.trim()).length() == 0) continue;
            if (className.equals(Default.class.getName())) {
                validationGroupsList.add(Default.class);
                continue;
            }
            try {
                validationGroupsList.add(Class.forName(className, false, Thread.currentThread().getContextClassLoader()));
            }
            catch (ClassNotFoundException e1) {
                try {
                    validationGroupsList.add(Class.forName(className));
                }
                catch (ClassNotFoundException e2) {
                    throw new FacesException("Validation group not found: " + className);
                }
            }
        }
        this.cachedValidationGroups = validationGroupsList.toArray(new Class[validationGroupsList.size()]);
        return this.cachedValidationGroups;
    }

    private boolean wholeBeanValidationEnabled(FacesContext context) {
        Map<Object, Object> attrs = context.getAttributes();
        return attrs.containsKey("javax.faces.validator.ENABLE_VALIDATE_WHOLE_BEAN") && (Boolean)attrs.get("javax.faces.validator.ENABLE_VALIDATE_WHOLE_BEAN") != false;
    }

    @Override
    public void markInitialState() {
        this.initialState = true;
    }

    @Override
    public boolean initialStateMarked() {
        return this.initialState;
    }

    @Override
    public void clearInitialState() {
        this.initialState = false;
    }

    @Override
    public boolean isTransient() {
        return this.transientValue;
    }

    @Override
    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object result = null;
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.validationGroups, super.saveState(context)};
            return values;
        }
        return result;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            this.validationGroups = (String)values[0];
            Object parentState = values[1];
            super.restoreState(context, parentState);
        }
    }

    private static enum PropertyKeys {
        ValidatorInstalled;

    }
}

