/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.InjectionApplicationFactory;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.context.InjectionFacesContextFactory;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FactoryConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACTORY = "factory";
    private static final String APPLICATION_FACTORY = "application-factory";
    private static final String EXCEPTION_HANDLER_FACTORY = "exception-handler-factory";
    private static final String FLASH_FACTORY = "flash-factory";
    private static final String VISIT_CONTEXT_FACTORY = "visit-context-factory";
    private static final String VIEW_DECLARATION_LANGUAGE_FACTORY = "view-declaration-language-factory";
    private static final String TAG_HANDLER_DELEGATE_FACTORY = "tag-handler-delegate-factory";
    private static final String FACELET_CACHE_FACTORY = "facelet-cache-factory";
    private static final String FACES_CONTEXT_FACTORY = "faces-context-factory";
    private static final String CLIENT_WINDOW_FACTORY = "client-window-factory";
    private static final String PARTIAL_VIEW_CONTEXT_FACTORY = "partial-view-context-factory";
    private static final String LIFECYCLE_FACTORY = "lifecycle-factory";
    private static final String RENDER_KIT_FACTORY = "render-kit-factory";
    private static final String EXTERNAL_CONTEXT_FACTORY = "external-context-factory";
    private static final String FLOW_HANDLER_FACTORY = "flow-handler-factory";
    private static final String[] FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.lifecycle.ClientWindowFactory", "javax.faces.context.ExceptionHandlerFactory", "javax.faces.context.ExternalContextFactory", "javax.faces.context.FacesContextFactory", "javax.faces.context.FlashFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.view.ViewDeclarationLanguageFactory", "javax.faces.context.PartialViewContextFactory", "javax.faces.render.RenderKitFactory", "javax.faces.component.visit.VisitContextFactory", "javax.faces.view.facelets.FaceletCacheFactory", "javax.faces.view.facelets.TagHandlerDelegateFactory", "javax.faces.flow.FlowHandlerFactory"};
    private boolean validateFactories = true;

    public FactoryConfigProcessor() {
    }

    public FactoryConfigProcessor(boolean validateFactories) {
        this.validateFactories = validateFactories;
    }

    @Override
    public void process(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        AtomicInteger facesContextFactoryCount = new AtomicInteger(0);
        AtomicInteger applicationFactoryCount = new AtomicInteger(0);
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing factory elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList factories = document.getDocumentElement().getElementsByTagNameNS(namespace, FACTORY);
            if (factories == null || factories.getLength() <= 0) continue;
            this.processFactories(factories, namespace, facesContextFactoryCount, applicationFactoryCount);
        }
        this.wrapFactories(applicationFactoryCount.get(), facesContextFactoryCount.get());
        this.verifyFactoriesExist();
        this.invokeNext(sc, documentInfos);
    }

    private void processFactories(NodeList factories, String namespace, AtomicInteger fcCount, AtomicInteger appCount) {
        int size = factories.getLength();
        for (int i = 0; i < size; ++i) {
            Node factory = factories.item(i);
            NodeList children = ((Element)factory).getElementsByTagNameNS(namespace, "*");
            int csize = children.getLength();
            block33: for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                switch (n.getLocalName()) {
                    case "application-factory": {
                        appCount.incrementAndGet();
                        FactoryConfigProcessor.setFactory("javax.faces.application.ApplicationFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "exception-handler-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.context.ExceptionHandlerFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "visit-context-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.component.visit.VisitContextFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "lifecycle-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.lifecycle.LifecycleFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "flash-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.context.FlashFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "client-window-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.lifecycle.ClientWindowFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "faces-context-factory": {
                        fcCount.incrementAndGet();
                        FactoryConfigProcessor.setFactory("javax.faces.context.FacesContextFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "render-kit-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.render.RenderKitFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "view-declaration-language-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.view.ViewDeclarationLanguageFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "tag-handler-delegate-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.view.facelets.TagHandlerDelegateFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "facelet-cache-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.view.facelets.FaceletCacheFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "external-context-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.context.ExternalContextFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "partial-view-context-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.context.PartialViewContextFactory", this.getNodeText(n));
                        continue block33;
                    }
                    case "flow-handler-factory": {
                        FactoryConfigProcessor.setFactory("javax.faces.flow.FlowHandlerFactory", this.getNodeText(n));
                    }
                }
            }
        }
    }

    private static void setFactory(String factoryName, String factoryImpl) {
        if (factoryName != null && factoryImpl != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling FactoryFinder.setFactory({0}, {1})", factoryName, factoryImpl));
            }
            FactoryFinder.setFactory(factoryName, factoryImpl);
        }
    }

    private void verifyFactoriesExist() {
        if (this.validateFactories) {
            int len = FACTORY_NAMES.length;
            for (int i = 0; i < len; ++i) {
                try {
                    FactoryFinder.getFactory(FACTORY_NAMES[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException(MessageFormat.format("Factory ''{0}'' was not configured properly.", FACTORY_NAMES[i]), e);
                }
            }
        }
    }

    private void wrapFactories(int appCount, int fcCount) {
        if (appCount > 1) {
            this.addInjectionApplicationFactory();
        }
        if (fcCount > 1) {
            this.addInjectionFacesContextFactory();
        }
    }

    private void addInjectionApplicationFactory() {
        FactoryFinder.setFactory("javax.faces.application.ApplicationFactory", InjectionApplicationFactory.class.getName());
    }

    private void addInjectionFacesContextFactory() {
        FactoryFinder.setFactory("javax.faces.context.FacesContextFactory", InjectionFacesContextFactory.class.getName());
    }
}

