/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.cdi;

import com.sun.faces.cdi.DefaultAnnotationLiteral;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.CollectionsUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.context.FacesContext;

abstract class CdiProducer<T>
implements Bean<T>,
PassivationCapable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean active;
    private String name;
    private Class<?> beanClass = Object.class;
    private Set<Type> types = Collections.singleton(Object.class);
    private Set<Annotation> qualifiers = Collections.singleton(new DefaultAnnotationLiteral());
    private Class<? extends Annotation> scope = Dependent.class;
    private Function<CreationalContext<T>, T> create;

    CdiProducer() {
    }

    public String getId() {
        return this.getClass().getName();
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public T create(CreationalContext<T> creationalContext) {
        this.checkActive();
        return this.create.apply(creationalContext);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    protected void checkActive() {
        if (this.active == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            WebConfiguration webConfig = WebConfiguration.getInstance(facesContext.getExternalContext());
            this.active = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableCdiResolverChain);
        }
        if (!this.active.booleanValue()) {
            throw new IllegalStateException("Cannot use @Inject without setting context-param \"javax.faces.ENABLE_CDI_RESOLVER_CHAIN\" to \"true\"");
        }
    }

    protected CdiProducer<T> active(boolean active) {
        this.active = active;
        return this;
    }

    protected CdiProducer<T> name(String name) {
        this.name = name;
        return this;
    }

    protected CdiProducer<T> create(Function<CreationalContext<T>, T> create) {
        this.create = create;
        return this;
    }

    protected CdiProducer<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    protected CdiProducer<T> types(Type ... types) {
        this.types = CollectionsUtils.asSet(types);
        return this;
    }

    protected CdiProducer<T> beanClassAndType(Class<?> beanClass) {
        this.beanClass(beanClass);
        this.types(beanClass);
        return this;
    }

    protected CdiProducer<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers = CollectionsUtils.asSet(qualifiers);
        return this;
    }

    protected CdiProducer<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }
}

