/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.facelets.impl.DefaultFaceletFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewMetadata;
import javax.faces.view.facelets.Facelet;

public class ViewMetadataImpl
extends ViewMetadata {
    private String viewId;
    private DefaultFaceletFactory faceletFactory;

    public ViewMetadataImpl(String viewId) {
        this.viewId = viewId;
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }

    @Override
    public UIViewRoot createMetadataView(FacesContext context) {
        UIViewRoot result = null;
        UIViewRoot currentViewRoot = context.getViewRoot();
        Map currentViewMapShallowCopy = Collections.emptyMap();
        try {
            Map<String, Object> currentViewMap;
            context.setProcessingEvents(false);
            if (this.faceletFactory == null) {
                ApplicationAssociate associate = ApplicationAssociate.getInstance(context.getExternalContext());
                this.faceletFactory = associate.getFaceletFactory();
                assert (this.faceletFactory != null);
            }
            ViewHandler vh = context.getApplication().getViewHandler();
            result = vh.createView(context, this.viewId);
            context.getAttributes().put("com.sun.faces.viewId", this.viewId);
            if (null != currentViewRoot && null != (currentViewMap = currentViewRoot.getViewMap(false)) && !currentViewMap.isEmpty()) {
                currentViewMapShallowCopy = new HashMap<String, Object>(currentViewMap);
                Map<String, Object> resultViewMap = result.getViewMap(true);
                resultViewMap.putAll(currentViewMapShallowCopy);
            }
            if (null != currentViewRoot) {
                context.setViewRoot(result);
            }
            Facelet f = this.faceletFactory.getMetadataFacelet(context, result.getViewId());
            f.apply(context, result);
        }
        catch (FacesFileNotFoundException ffnfe) {
            try {
                context.getExternalContext().responseSendError(404, ffnfe.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            context.responseComplete();
        }
        catch (IOException ioe) {
            throw new FacesException(ioe);
        }
        finally {
            context.getAttributes().remove("com.sun.faces.viewId");
            context.setProcessingEvents(true);
            if (null != currentViewRoot) {
                context.setViewRoot(currentViewRoot);
                if (!currentViewMapShallowCopy.isEmpty()) {
                    currentViewRoot.getViewMap(true).putAll(currentViewMapShallowCopy);
                    currentViewMapShallowCopy.clear();
                }
            }
        }
        return result;
    }
}

