/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CollectionHandler;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.VariableAggregationDefinition;
import org.flowable.bpmn.model.VariableAggregationDefinitions;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.FlowableMultiInstanceActivityCompletedEvent;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.delegate.variable.VariableAggregator;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ClassDelegateCollectionHandler;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionCollectionHandler;
import org.flowable.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.BaseVariableAggregatorContext;
import org.flowable.engine.impl.delegate.FlowableCollectionHandler;
import org.flowable.engine.impl.delegate.InterruptibleActivityBehaviour;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ExecutionGraphUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.variable.BpmnAggregation;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiInstanceActivityBehavior
extends FlowNodeActivityBehavior
implements SubProcessActivityBehavior,
InterruptibleActivityBehaviour {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(MultiInstanceActivityBehavior.class);
    protected static final String DELETE_REASON_END = "MI_END";
    protected static final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected static final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    protected static final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected Activity activity;
    protected AbstractBpmnActivityBehavior innerActivityBehavior;
    protected Expression loopCardinalityExpression;
    protected String completionCondition;
    protected Expression collectionExpression;
    protected String collectionVariable;
    protected String collectionElementVariable;
    protected String collectionString;
    protected CollectionHandler collectionHandler;
    protected VariableAggregationDefinitions aggregations;
    protected String collectionElementIndexVariable = "loopCounter";

    public MultiInstanceActivityBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.activity = activity;
        this.setInnerActivityBehavior(innerActivityBehavior);
    }

    @Override
    public void execute(DelegateExecution delegateExecution) {
        ExecutionEntity execution = (ExecutionEntity)delegateExecution;
        if (this.getLocalLoopVariable(execution, this.getCollectionElementIndexVariable()) == null) {
            int nrOfInstances = 0;
            if (this.hasVariableAggregationDefinitions(delegateExecution)) {
                Map<String, VariableAggregationDefinition> aggregationsByTarget = BpmnAggregation.groupAggregationsByTarget(delegateExecution, this.aggregations.getOverviewAggregations(), CommandContextUtil.getProcessEngineConfiguration());
                for (String variableName : aggregationsByTarget.keySet()) {
                    BpmnAggregation bpmnAggregation = new BpmnAggregation(delegateExecution.getId());
                    delegateExecution.setVariable(variableName, bpmnAggregation);
                }
            }
            try {
                nrOfInstances = this.createInstances(delegateExecution);
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, (DelegateExecution)execution);
            }
            if (nrOfInstances == 0) {
                this.cleanupMiRoot(execution);
            }
        } else {
            if (this.activity.isAsynchronous()) {
                CommandContextUtil.getActivityInstanceEntityManager().recordActivityStart(execution);
            }
            this.innerActivityBehavior.execute(execution);
        }
    }

    protected abstract int createInstances(DelegateExecution var1);

    @Override
    public void leave(DelegateExecution execution) {
        this.cleanupMiRoot(execution);
    }

    protected boolean hasVariableAggregationDefinitions(DelegateExecution execution) {
        return this.aggregations != null && !this.aggregations.getAggregations().isEmpty();
    }

    protected void aggregateVariablesForChildExecution(DelegateExecution childExecution, DelegateExecution miRootExecution) {
        if (this.hasVariableAggregationDefinitions(childExecution) && miRootExecution != null) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
            VariableServiceConfiguration variableServiceConfiguration = processEngineConfiguration.getVariableServiceConfiguration();
            VariableService variableService = variableServiceConfiguration.getVariableService();
            for (VariableAggregationDefinition aggregation : this.aggregations.getAggregations()) {
                VariableInstanceEntity aggregatedVarInstance = BpmnAggregation.aggregateComplete(childExecution, miRootExecution, aggregation, processEngineConfiguration);
                if (aggregatedVarInstance == null) continue;
                variableService.insertVariableInstance(aggregatedVarInstance);
                String targetVarName = aggregatedVarInstance.getName();
                Integer elementIndexValue = this.getLoopVariable(childExecution, this.getCollectionElementIndexVariable());
                String counterValue = aggregatedVarInstance.getId() + "###" + elementIndexValue;
                VariableInstanceEntity counterVarInstance = BpmnAggregation.createScopedVariableAggregationVariableInstance("__flowableCounter__" + targetVarName, aggregatedVarInstance.getScopeId(), aggregatedVarInstance.getSubScopeId(), counterValue, variableServiceConfiguration);
                variableService.insertVariableInstance(counterVarInstance);
            }
        }
    }

    protected void aggregateVariablesOfAllInstances(DelegateExecution multiInstanceRootExecution) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        VariableService variableService = processEngineConfiguration.getVariableServiceConfiguration().getVariableService();
        List instances = variableService.createInternalVariableInstanceQuery().subScopeId(multiInstanceRootExecution.getId()).scopeType("bpmnVariableAggregation").list();
        Map<String, VariableAggregationDefinition> aggregationsByTarget = BpmnAggregation.groupAggregationsByTarget(multiInstanceRootExecution, this.aggregations.getAggregations(), processEngineConfiguration);
        Map<String, List<VariableInstance>> instancesByName = BpmnAggregation.groupVariableInstancesByName(instances);
        for (Map.Entry<String, VariableAggregationDefinition> entry : aggregationsByTarget.entrySet()) {
            String varName = entry.getKey();
            VariableAggregationDefinition aggregation = aggregationsByTarget.get(varName);
            VariableAggregator aggregator = BpmnAggregation.resolveVariableAggregator(aggregation, multiInstanceRootExecution);
            List<VariableInstance> varValues = instancesByName.getOrDefault(varName, Collections.emptyList());
            List<VariableInstance> counterVariables = instancesByName.getOrDefault("__flowableCounter__" + varName, Collections.emptyList());
            BpmnAggregation.sortVariablesByCounter(varValues, counterVariables);
            Object value = aggregator.aggregateMultiVariables(multiInstanceRootExecution, varValues, BaseVariableAggregatorContext.complete(aggregation));
            if (aggregation.isStoreAsTransientVariable()) {
                multiInstanceRootExecution.getParent().setTransientVariable(varName, value);
                continue;
            }
            multiInstanceRootExecution.getParent().setVariable(varName, value);
        }
    }

    protected void cleanupMiRoot(DelegateExecution execution) {
        ExecutionEntity multiInstanceRootExecution = (ExecutionEntity)this.getMultiInstanceRootExecution(execution);
        if (this.hasVariableAggregationDefinitions(execution)) {
            this.aggregateVariablesOfAllInstances(multiInstanceRootExecution);
        }
        FlowElement flowElement = multiInstanceRootExecution.getCurrentFlowElement();
        ExecutionEntity parentExecution = multiInstanceRootExecution.getParent();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        List<String> executionIdsNotToSendCancelledEventsFor = execution.isMultiInstanceRoot() ? null : Collections.singletonList(execution.getId());
        executionEntityManager.deleteChildExecutions(multiInstanceRootExecution, null, executionIdsNotToSendCancelledEventsFor, DELETE_REASON_END, true, flowElement);
        executionEntityManager.deleteRelatedDataForExecution(multiInstanceRootExecution, DELETE_REASON_END, false);
        executionEntityManager.delete(multiInstanceRootExecution);
        ExecutionEntity newExecution = executionEntityManager.createChildExecution(parentExecution);
        newExecution.setCurrentFlowElement(flowElement);
        super.leave(newExecution);
    }

    protected void executeCompensationBoundaryEvents(FlowElement flowElement, DelegateExecution execution) {
        Collection<BoundaryEvent> boundaryEvents = this.findBoundaryEventsForFlowNode(execution.getProcessDefinitionId(), flowElement);
        if (CollectionUtil.isNotEmpty(boundaryEvents)) {
            for (BoundaryEvent boundaryEvent : boundaryEvents) {
                if (CollectionUtil.isEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                ExecutionEntity childExecutionEntity = CommandContextUtil.getExecutionEntityManager().createChildExecution((ExecutionEntity)execution);
                childExecutionEntity.setParentId(execution.getId());
                childExecutionEntity.setCurrentFlowElement((FlowElement)boundaryEvent);
                childExecutionEntity.setScope(false);
                ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
                boundaryEventBehavior.execute(childExecutionEntity);
            }
        }
    }

    protected Collection<BoundaryEvent> findBoundaryEventsForFlowNode(String processDefinitionId, FlowElement flowElement) {
        Process process = this.getProcessDefinition(processDefinitionId);
        ArrayList<BoundaryEvent> results = new ArrayList<BoundaryEvent>(1);
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (boundaryEvent.getAttachedToRefId() == null || !boundaryEvent.getAttachedToRefId().equals(flowElement.getId())) continue;
            results.add(boundaryEvent);
        }
        return results;
    }

    protected Process getProcessDefinition(String processDefinitionId) {
        return ProcessDefinitionUtil.getProcess(processDefinitionId);
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        this.innerActivityBehavior.trigger(execution, signalName, signalData);
    }

    public void lastExecutionEnded(DelegateExecution execution) {
        this.leave(execution);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        if (this.innerActivityBehavior instanceof SubProcessActivityBehavior) {
            ((SubProcessActivityBehavior)((Object)this.innerActivityBehavior)).completing(execution, subProcessInstance);
        }
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
        this.leave(execution);
    }

    @Override
    public void interrupted(DelegateExecution execution) {
        if (this.hasVariableAggregationDefinitions(execution)) {
            Map<String, VariableAggregationDefinition> aggregationsByTarget = BpmnAggregation.groupAggregationsByTarget(execution, this.aggregations.getOverviewAggregations(), CommandContextUtil.getProcessEngineConfiguration());
            for (String variableName : aggregationsByTarget.keySet()) {
                VariableInstance variableInstance = execution.getVariableInstance(variableName);
                if (variableInstance == null || !"bpmnAggregation".equals(variableInstance.getTypeName())) continue;
                execution.removeVariable(variableName);
            }
        }
        if (this.innerActivityBehavior instanceof InterruptibleActivityBehaviour) {
            ((InterruptibleActivityBehaviour)((Object)this.innerActivityBehavior)).interrupted(execution);
        }
    }

    public boolean completionConditionSatisfied(DelegateExecution execution) {
        if (this.completionCondition != null) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
            ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
            String activeCompletionCondition = null;
            if (CommandContextUtil.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
                ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.activity.getId(), execution.getProcessDefinitionId());
                activeCompletionCondition = this.getActiveValue(this.completionCondition, "multiInstanceCompletionCondition", taskElementProperties);
            } else {
                activeCompletionCondition = this.completionCondition;
            }
            Object value = expressionManager.createExpression(activeCompletionCondition).getValue((VariableContainer)execution);
            if (!(value instanceof Boolean)) {
                throw new FlowableIllegalArgumentException("completionCondition '" + activeCompletionCondition + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    public Integer getLoopVariable(DelegateExecution execution, String variableName) {
        VariableInstance variable = this.getLoopVariableInstance(execution, variableName);
        Object value = variable != null ? variable.getValue() : Integer.valueOf(0);
        return (Integer)(value != null ? value : Integer.valueOf(0));
    }

    public VariableInstance getLoopVariableInstance(DelegateExecution execution, String variableName) {
        VariableInstance variable = execution.getVariableInstanceLocal(variableName);
        for (DelegateExecution parent = execution.getParent(); variable == null && parent != null; parent = parent.getParent()) {
            variable = parent.getVariableInstanceLocal(variableName);
        }
        return variable;
    }

    protected void sendCompletedWithConditionEvent(DelegateExecution execution) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)this.buildCompletedEvent(execution, FlowableEngineEventType.MULTI_INSTANCE_ACTIVITY_COMPLETED_WITH_CONDITION), processEngineConfiguration.getEngineCfgKey());
    }

    protected void sendCompletedEvent(DelegateExecution execution) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)this.buildCompletedEvent(execution, FlowableEngineEventType.MULTI_INSTANCE_ACTIVITY_COMPLETED), processEngineConfiguration.getEngineCfgKey());
    }

    protected FlowableMultiInstanceActivityCompletedEvent buildCompletedEvent(DelegateExecution execution, FlowableEngineEventType eventType) {
        FlowElement flowNode = execution.getCurrentFlowElement();
        return FlowableEventBuilder.createMultiInstanceActivityCompletedEvent(eventType, this.getLoopVariable(execution, NUMBER_OF_INSTANCES), this.getLoopVariable(execution, NUMBER_OF_ACTIVE_INSTANCES), this.getLoopVariable(execution, NUMBER_OF_COMPLETED_INSTANCES), flowNode.getId(), flowNode.getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), flowNode);
    }

    protected int resolveNrOfInstances(DelegateExecution execution) {
        if (this.loopCardinalityExpression != null) {
            return this.resolveLoopCardinality(execution);
        }
        if (this.usesCollection()) {
            Collection collection = this.resolveAndValidateCollection(execution);
            return collection.size();
        }
        throw new FlowableIllegalArgumentException("Couldn't resolve collection expression nor variable reference");
    }

    protected void executeOriginalBehavior(DelegateExecution execution, ExecutionEntity multiInstanceRootExecution, int loopCounter) {
        if (this.usesCollection() && this.collectionElementVariable != null) {
            Collection collection = this.resolveAndValidateCollection(execution);
            Object value = null;
            Iterator it = collection.iterator();
            for (int index = 0; index <= loopCounter; ++index) {
                value = it.next();
            }
            this.setLoopVariable(execution, this.collectionElementVariable, value);
        }
        execution.setCurrentFlowElement((FlowElement)this.activity);
        CommandContextUtil.getAgenda().planContinueMultiInstanceOperation((ExecutionEntity)execution, multiInstanceRootExecution, loopCounter);
    }

    protected Collection resolveAndValidateCollection(DelegateExecution execution) {
        Object obj = this.resolveCollection(execution);
        if (this.collectionHandler != null) {
            return this.createFlowableCollectionHandler(this.collectionHandler, execution).resolveCollection(obj, execution);
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof Iterable) {
            return this.iterableToCollection((Iterable)obj);
        }
        if (obj instanceof String) {
            Object collectionVariable = execution.getVariable((String)obj);
            if (collectionVariable instanceof Collection) {
                return (Collection)collectionVariable;
            }
            if (collectionVariable instanceof Iterable) {
                return this.iterableToCollection((Iterable)collectionVariable);
            }
            if (collectionVariable == null) {
                throw new FlowableIllegalArgumentException("Variable '" + obj + "' was not found");
            }
            throw new FlowableIllegalArgumentException("Variable '" + obj + "':" + collectionVariable + " is not a Collection");
        }
        throw new FlowableIllegalArgumentException("Couldn't resolve collection expression, variable reference or string");
    }

    protected Collection iterableToCollection(Iterable iterable) {
        ArrayList result = new ArrayList();
        iterable.forEach(element -> result.add(element));
        return result;
    }

    protected Object resolveCollection(DelegateExecution execution) {
        Object collection = null;
        if (this.collectionExpression != null) {
            collection = this.collectionExpression.getValue((VariableContainer)execution);
        } else if (this.collectionVariable != null) {
            collection = execution.getVariable(this.collectionVariable);
        } else if (this.collectionString != null) {
            collection = this.collectionString;
        }
        return collection;
    }

    protected boolean usesCollection() {
        return this.collectionExpression != null || this.collectionVariable != null || this.collectionString != null;
    }

    protected boolean isExtraScopeNeeded(FlowNode flowNode) {
        return flowNode.getSubProcess() != null;
    }

    protected int resolveLoopCardinality(DelegateExecution execution) {
        Object value = this.loopCardinalityExpression.getValue((VariableContainer)execution);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new FlowableIllegalArgumentException("Could not resolve loopCardinality expression '" + this.loopCardinalityExpression.getExpressionText() + "': not a number nor number String");
    }

    protected void setLoopVariable(DelegateExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected Integer getLocalLoopVariable(DelegateExecution execution, String variableName) {
        Map localVariables = execution.getVariablesLocal();
        if (localVariables.containsKey(variableName)) {
            return (Integer)execution.getVariableLocal(variableName);
        }
        if (!execution.isMultiInstanceRoot()) {
            DelegateExecution parentExecution = execution.getParent();
            localVariables = parentExecution.getVariablesLocal();
            if (localVariables.containsKey(variableName)) {
                return (Integer)parentExecution.getVariableLocal(variableName);
            }
            if (!parentExecution.isMultiInstanceRoot()) {
                DelegateExecution superExecution = parentExecution.getParent();
                return (Integer)superExecution.getVariableLocal(variableName);
            }
            return null;
        }
        return null;
    }

    protected void callActivityEndListeners(DelegateExecution execution) {
        CommandContextUtil.getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners((HasExecutionListeners)this.activity, execution, "end");
    }

    protected void logLoopDetails(DelegateExecution execution, String custom, int loopCounter, int nrOfCompletedInstances, int nrOfActiveInstances, int nrOfInstances) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Multi-instance '{}' {}. Details: loopCounter={}, nrOrCompletedInstances={},nrOfActiveInstances={},nrOfInstances={}", new Object[]{execution.getCurrentFlowElement() != null ? execution.getCurrentFlowElement().getId() : "", custom, loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances});
        }
    }

    protected DelegateExecution getMultiInstanceRootExecution(DelegateExecution execution) {
        return ExecutionGraphUtil.getMultiInstanceRootExecution((ExecutionEntity)execution);
    }

    protected DelegateExecution getInstanceExecution(DelegateExecution execution) {
        return ExecutionGraphUtil.getParentInstanceExecutionInMultiInstance((ExecutionEntity)execution);
    }

    protected String getActiveValue(String originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }

    protected FlowableCollectionHandler createFlowableCollectionHandler(CollectionHandler handler, DelegateExecution execution) {
        FlowableCollectionHandler collectionHandler = null;
        if ("class".equalsIgnoreCase(handler.getImplementationType())) {
            collectionHandler = new ClassDelegateCollectionHandler(handler.getImplementation(), null);
        } else if ("delegateExpression".equalsIgnoreCase(handler.getImplementationType())) {
            Object delegate = DelegateExpressionUtil.resolveDelegateExpression(CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(handler.getImplementation()), execution);
            if (delegate instanceof FlowableCollectionHandler) {
                collectionHandler = new DelegateExpressionCollectionHandler(execution, CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(handler.getImplementation()));
            } else {
                throw new FlowableIllegalArgumentException("Delegate expression " + handler.getImplementation() + " did not resolve to an implementation of " + FlowableCollectionHandler.class);
            }
        }
        return collectionHandler;
    }

    public Expression getLoopCardinalityExpression() {
        return this.loopCardinalityExpression;
    }

    public void setLoopCardinalityExpression(Expression loopCardinalityExpression) {
        this.loopCardinalityExpression = loopCardinalityExpression;
    }

    public String getCompletionCondition() {
        return this.completionCondition;
    }

    public void setCompletionCondition(String completionCondition) {
        this.completionCondition = completionCondition;
    }

    public Expression getCollectionExpression() {
        return this.collectionExpression;
    }

    public void setCollectionExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    public String getCollectionVariable() {
        return this.collectionVariable;
    }

    public void setCollectionVariable(String collectionVariable) {
        this.collectionVariable = collectionVariable;
    }

    public String getCollectionElementVariable() {
        return this.collectionElementVariable;
    }

    public void setCollectionElementVariable(String collectionElementVariable) {
        this.collectionElementVariable = collectionElementVariable;
    }

    public String getCollectionString() {
        return this.collectionString;
    }

    public void setCollectionString(String collectionString) {
        this.collectionString = collectionString;
    }

    public CollectionHandler getHandler() {
        return this.collectionHandler;
    }

    public void setHandler(CollectionHandler collectionHandler) {
        this.collectionHandler = collectionHandler;
    }

    public VariableAggregationDefinitions getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(VariableAggregationDefinitions aggregations) {
        this.aggregations = aggregations;
    }

    public String getCollectionElementIndexVariable() {
        return this.collectionElementIndexVariable;
    }

    public void setCollectionElementIndexVariable(String collectionElementIndexVariable) {
        this.collectionElementIndexVariable = collectionElementIndexVariable;
    }

    public void setInnerActivityBehavior(AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.innerActivityBehavior = innerActivityBehavior;
        this.innerActivityBehavior.setMultiInstanceActivityBehavior(this);
    }

    public AbstractBpmnActivityBehavior getInnerActivityBehavior() {
        return this.innerActivityBehavior;
    }
}

