/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.logging;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.firebirdsql.logging.ConsoleLogger;
import org.firebirdsql.logging.JulLogger;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.NullLogger;

public final class LoggerFactory {
    private static final Logger NULL_LOGGER = new NullLogger();
    private static final LoggerCreator loggerCreator;
    public static final String FORCE_CONSOLE_LOGGER_PROP = "org.firebirdsql.jdbc.forceConsoleLogger";
    public static final String DISABLE_LOGGING_PROP = "org.firebirdsql.jdbc.disableLogging";
    public static final String LOGGER_IMPLEMENTATION_PROP = "org.firebirdsql.jdbc.loggerImplementation";

    private LoggerFactory() {
    }

    public static Logger getLogger(String name) {
        return loggerCreator.createLogger(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    private static String getSystemPropertyPrivileged(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }

    private static LoggerCreator getLoggerCreator(String loggerImplementationClassName, boolean forceConsoleLogger, boolean disableLogging) {
        if (disableLogging) {
            return new NullLoggerCreator();
        }
        if (forceConsoleLogger || ConsoleLogger.class.getName().equals(loggerImplementationClassName)) {
            return new ConsoleLoggerCreator();
        }
        if (loggerImplementationClassName == null || JulLogger.class.getName().equals(loggerImplementationClassName)) {
            return JulLoggerCreator.INSTANCE;
        }
        try {
            return new ReflectionLoggerCreator(loggerImplementationClassName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JulLoggerCreator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LoggerCreator tempLoggerCreator = JulLoggerCreator.INSTANCE;
        try {
            String sForceConsoleLogger = LoggerFactory.getSystemPropertyPrivileged(FORCE_CONSOLE_LOGGER_PROP);
            String sDisableLogging = LoggerFactory.getSystemPropertyPrivileged(DISABLE_LOGGING_PROP);
            String sLoggerImplementation = LoggerFactory.getSystemPropertyPrivileged(LOGGER_IMPLEMENTATION_PROP);
            boolean bForceConsoleLogger = "true".equalsIgnoreCase(sForceConsoleLogger);
            boolean bDisableLogging = "true".equalsIgnoreCase(sDisableLogging);
            tempLoggerCreator = LoggerFactory.getLoggerCreator(sLoggerImplementation, bForceConsoleLogger, bDisableLogging);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            loggerCreator = tempLoggerCreator;
        }
    }

    private static class ReflectionLoggerCreator
    implements LoggerCreator {
        private final Class<? extends Logger> loggerClass;
        private final Constructor<? extends Logger> loggerConstructor;

        ReflectionLoggerCreator(String loggerImplementationClassName) throws ClassNotFoundException, NoSuchMethodException {
            Class<?> loggerClassCandidate = Class.forName(loggerImplementationClassName);
            if (!Logger.class.isAssignableFrom(loggerClassCandidate)) {
                throw new IllegalArgumentException(loggerImplementationClassName + " does not implement org.firebirdsql.logging.Logger");
            }
            this.loggerClass = loggerClassCandidate;
            this.loggerConstructor = this.loggerClass.getConstructor(String.class);
        }

        @Override
        public Logger createLogger(String name) {
            try {
                return this.loggerConstructor.newInstance(name);
            }
            catch (Exception e) {
                e.printStackTrace();
                return NULL_LOGGER;
            }
        }
    }

    private static class ConsoleLoggerCreator
    implements LoggerCreator {
        private ConsoleLoggerCreator() {
        }

        @Override
        public Logger createLogger(String name) {
            return new ConsoleLogger(name);
        }
    }

    private static class NullLoggerCreator
    implements LoggerCreator {
        private NullLoggerCreator() {
        }

        @Override
        public Logger createLogger(String name) {
            return NULL_LOGGER;
        }
    }

    private static class JulLoggerCreator
    implements LoggerCreator {
        private static JulLoggerCreator INSTANCE = new JulLoggerCreator();

        private JulLoggerCreator() {
        }

        @Override
        public Logger createLogger(String name) {
            return new JulLogger(name);
        }
    }

    private static interface LoggerCreator {
        public Logger createLogger(String var1);
    }
}

