/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TypeConversionException;

final class FBTimeField
extends FBField {
    FBTimeField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getDatatypeCoder().decodeTime(this.getFieldData()));
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTimeCalendar(this.getFieldData(), cal);
    }

    @Override
    public Time getTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTime(this.getFieldData());
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.getDatatypeCoder().decodeTimeCalendar(this.getFieldData(), cal).getTime());
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.getTime().getTime());
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        try {
            this.setTime(Time.valueOf(value));
        }
        catch (RuntimeException e) {
            TypeConversionException conversionException = new TypeConversionException("Error converting to time.");
            conversionException.initCause(e);
            throw conversionException;
        }
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimeCalendar(new Time(value.getTime()), cal));
    }

    @Override
    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setTime(new Time(value.getTime()));
    }

    @Override
    public void setTime(Time value, Calendar cal) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimeCalendar(value, cal));
    }

    @Override
    public void setTime(Time value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTime(value));
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct getRawDateTimeStruct() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTimeRaw(this.getFieldData());
    }

    @Override
    public void setRawDateTimeStruct(DatatypeCoder.RawDateTimeStruct raw) throws SQLException {
        if (raw == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimeRaw(raw));
    }
}

