/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import javax.resource.ResourceException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBXAException;

public class FBSQLException
extends SQLException {
    private static final long serialVersionUID = 8157410954186424083L;
    @Deprecated
    public static final String SQL_STATE_INVALID_CONN_ATTR = "01S00";
    @Deprecated
    public static final String SQL_STATE_NO_ROW_AVAIL = "01S06";
    @Deprecated
    public static final String SQL_STATE_GENERAL_ERROR = "HY000";
    @Deprecated
    public static final String SQL_STATE_INVALID_COLUMN = "HY002";
    @Deprecated
    public static final String SQL_STATE_INVALID_ARG_VALUE = "HY009";
    @Deprecated
    public static final String SQL_STATE_INVALID_OPTION_IDENTIFIER = "HY092";
    @Deprecated
    public static final String SQL_STATE_INVALID_PARAM_TYPE = "HY105";
    @Deprecated
    public static final String SQL_STATE_WRONG_PARAM_NUM = "07001";
    @Deprecated
    public static final String SQL_STATE_NO_RESULT_SET = "07005";
    @Deprecated
    public static final String SQL_STATE_INVALID_CONVERSION = "07006";
    @Deprecated
    public static final String SQL_STATE_INVALID_TX_STATE = "25000";
    @Deprecated
    public static final String SQL_STATE_INVALID_STATEMENT_ID = "26000";
    @Deprecated
    public static final String SQL_STATE_CONNECTION_ERROR = "08000";
    @Deprecated
    public static final String SQL_STATE_CONNECTION_CLOSED = "08003";
    @Deprecated
    public static final String SQL_STATE_CONNECTION_FAILURE = "08006";
    @Deprecated
    public static final String SQL_STATE_CONNECTION_FAILURE_IN_TX = "08007";
    @Deprecated
    public static final String SQL_STATE_COMM_LINK_FAILURE = "08S01";
    @Deprecated
    public static final String SQL_STATE_SYNTAX_ERROR = "42000";

    public FBSQLException(Exception ex) {
        this("Exception. " + ex.getMessage());
        this.initCause(ex);
    }

    public FBSQLException(GDSException ex) {
        super(FBSQLException.createGDSExceptionMessage(ex), FBSQLException.defaultSQLStateIfNull(ex.getSQLState()), ex.getIntParam(), ex);
    }

    public FBSQLException(ResourceException ex) {
        super(FBSQLException.createResourceMessage(ex), FBSQLException.defaultSQLStateIfNull(ex.getErrorCode()), FBSQLException.getSqlErrorCode(ex), FBSQLException.resolveCause(ex));
    }

    public FBSQLException(String message) {
        super(message, SQL_STATE_GENERAL_ERROR);
    }

    @Deprecated
    public FBSQLException(String message, SQLException ex) {
        this(message);
        this.setNextException(ex);
    }

    public FBSQLException(String message, String sqlState) {
        super(message, FBSQLException.defaultSQLStateIfNull(sqlState));
    }

    @Deprecated
    public Exception getInternalException() {
        return (Exception)this.getCause();
    }

    private static String createResourceMessage(ResourceException ex) {
        Throwable cause = FBSQLException.resolveCause(ex);
        if (cause instanceof GDSException) {
            return FBSQLException.createGDSExceptionMessage((GDSException)cause);
        }
        return "Resource Exception. " + ex.getMessage();
    }

    private static String createGDSExceptionMessage(GDSException ex) {
        return "GDS Exception. " + ex.getIntParam() + ". " + ex.getMessage();
    }

    private static int getSqlErrorCode(ResourceException ex) {
        FBXAException fbXaException;
        Throwable cause2;
        Throwable cause = FBSQLException.resolveCause(ex);
        if (cause instanceof GDSException) {
            return ((GDSException)cause).getIntParam();
        }
        if (cause instanceof SQLException) {
            return ((SQLException)cause).getErrorCode();
        }
        if (cause instanceof FBXAException && (cause2 = (fbXaException = (FBXAException)cause).getCause()) instanceof SQLException) {
            return ((SQLException)cause2).getErrorCode();
        }
        return 0;
    }

    private static Throwable resolveCause(ResourceException ex) {
        if (ex instanceof FBResourceException && ex.getLinkedException() != null) {
            return ex.getLinkedException();
        }
        return ex;
    }

    public static String defaultSQLStateIfNull(String sqlState) {
        return sqlState != null ? sqlState : SQL_STATE_GENERAL_ERROR;
    }
}

