/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version13;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Objects;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.WireCrypt;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptData;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionInitInfo;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPlugin;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPluginSpi;
import org.firebirdsql.gds.ng.wire.crypt.arc4.Arc4EncryptionPluginSpi;
import org.firebirdsql.gds.ng.wire.version11.V11WireOperations;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class V13WireOperations
extends V11WireOperations {
    private static final Logger log = LoggerFactory.getLogger(V13WireOperations.class);

    public V13WireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback, Object syncObject) {
        super(connection, defaultWarningMessageCallback, syncObject);
    }

    @Override
    public void authReceiveResponse(FbWireAttachment.AcceptPacket acceptPacket, DbCryptCallback dbCryptCallback, FbWireOperations.ProcessAttachCallback processAttachCallback) throws SQLException, IOException {
        assert (acceptPacket == null || acceptPacket.operation == 98) : "Unexpected operation in AcceptPacket";
        XdrInputStream xdrIn = this.getXdrIn();
        XdrOutputStream xdrOut = this.getXdrOut();
        ClientAuthBlock clientAuthBlock = this.getClientAuthBlock();
        Encoding encoding = this.getEncoding();
        block7: while (true) {
            String pluginName;
            byte[] data;
            if (acceptPacket != null) {
                data = acceptPacket.p_acpt_data;
                pluginName = acceptPacket.p_acpt_plugin;
                this.addServerKeys(acceptPacket.p_acpt_keys);
                log.debug(String.format("authReceiveResponse: cond_accept data=%d pluginName=%d '%s'", data.length, pluginName != null ? Integer.valueOf(pluginName.length()) : null, pluginName));
                acceptPacket = null;
            } else {
                int operation = this.readNextOperation();
                switch (operation) {
                    case 90: {
                        xdrIn.readBuffer();
                        throw new FbExceptionBuilder().nonTransientConnectionException(337248272).toFlatSQLException();
                    }
                    case 92: {
                        data = xdrIn.readBuffer();
                        pluginName = xdrIn.readString(encoding);
                        xdrIn.readBuffer();
                        this.addServerKeys(xdrIn.readBuffer());
                        log.debug(String.format("authReceiveResponse: cont_auth data=%d pluginName=%d '%s'", data.length, pluginName.length(), pluginName));
                        break;
                    }
                    case 97: {
                        log.debug("Handling db crypt callback using plugin " + dbCryptCallback.getDbCryptCallbackName());
                        this.handleCryptKeyCallback(dbCryptCallback);
                        continue block7;
                    }
                    case 98: {
                        xdrIn.readInt();
                        xdrIn.readInt();
                        xdrIn.readInt();
                        data = xdrIn.readBuffer();
                        pluginName = xdrIn.readString(encoding);
                        xdrIn.readInt();
                        this.addServerKeys(xdrIn.readBuffer());
                        log.debug(String.format("authReceiveResponse: cond_accept data=%d pluginName=%d '%s'", data.length, pluginName.length(), pluginName));
                        break;
                    }
                    case 9: {
                        GenericResponse response = (GenericResponse)this.readOperationResponse(operation, null);
                        boolean wasAuthComplete = clientAuthBlock.isAuthComplete();
                        clientAuthBlock.setAuthComplete(true);
                        processAttachCallback.processAttachResponse(response);
                        this.addServerKeys(response.getData());
                        WireCrypt wireCrypt = this.getAttachProperties().getWireCrypt();
                        if (!wasAuthComplete && wireCrypt != WireCrypt.DISABLED) {
                            this.tryKnownServerKeys();
                        }
                        return;
                    }
                    default: {
                        throw new SQLException(String.format("Unsupported operation code: %d", operation));
                    }
                }
            }
            if (pluginName != null && pluginName.length() > 0 && Objects.equals(pluginName, clientAuthBlock.getCurrentPluginName())) {
                pluginName = null;
            }
            if (pluginName != null && pluginName.length() > 0 && !clientAuthBlock.switchPlugin(pluginName) || !clientAuthBlock.hasPlugin()) break;
            clientAuthBlock.setServerData(data);
            log.debug(String.format("receiveResponse: authenticate(%s)", clientAuthBlock.getCurrentPluginName()));
            clientAuthBlock.authenticate();
            xdrOut.writeInt(92);
            xdrOut.writeBuffer(clientAuthBlock.getClientData());
            xdrOut.writeString(clientAuthBlock.getCurrentPluginName(), encoding);
            if (clientAuthBlock.isFirstTime()) {
                xdrOut.writeString(clientAuthBlock.getPluginNames(), encoding);
                clientAuthBlock.setFirstTime(false);
            } else {
                xdrOut.writeBuffer(null);
            }
            xdrOut.writeBuffer(null);
            xdrOut.flush();
        }
        throw new FbExceptionBuilder().exception(335544472).toFlatSQLException();
    }

    private void tryKnownServerKeys() throws IOException, SQLException {
        boolean initializedEncryption = false;
        SQLExceptionChainBuilder<SQLException> chainBuilder = new SQLExceptionChainBuilder<SQLException>();
        HashMap<EncryptionIdentifier, Arc4EncryptionPluginSpi> supportedEncryptionPlugins = new HashMap<EncryptionIdentifier, Arc4EncryptionPluginSpi>();
        Arc4EncryptionPluginSpi encryptionPluginSpi = new Arc4EncryptionPluginSpi();
        supportedEncryptionPlugins.put(encryptionPluginSpi.getEncryptionIdentifier(), encryptionPluginSpi);
        for (EncryptionIdentifier encryptionIdentifier : this.getEncryptionIdentifiers()) {
            EncryptionPluginSpi currentEncryptionSpi = (EncryptionPluginSpi)supportedEncryptionPlugins.get(encryptionIdentifier);
            if (currentEncryptionSpi == null) continue;
            EncryptionPlugin encryptionPlugin = currentEncryptionSpi.createEncryptionPlugin(this.getConnection());
            EncryptionInitInfo encryptionInitInfo = encryptionPlugin.initializeEncryption();
            if (encryptionInitInfo.isSuccess()) {
                this.enableEncryption(encryptionInitInfo);
                this.clearServerKeys();
                initializedEncryption = true;
                log.debug("Wire encryption established with " + encryptionIdentifier);
                break;
            }
            chainBuilder.append(encryptionInitInfo.getException());
        }
        if (!initializedEncryption && this.getAttachProperties().getWireCrypt() == WireCrypt.REQUIRED) {
            SQLException exception = new FbExceptionBuilder().nonTransientException(335545064).toFlatSQLException();
            if (chainBuilder.hasException()) {
                exception.setNextException((SQLException)chainBuilder.getException());
            }
            throw exception;
        }
        if (chainBuilder.hasException()) {
            log.warn(initializedEncryption ? "No wire encryption established because of errors" : "Wire encryption established, but some plugins failed; see other loglines for details");
            Object current = chainBuilder.getException();
            do {
                log.warn("Encryption plugin failed", (Throwable)current);
            } while ((current = ((SQLException)current).getNextException()) != null);
        }
    }

    protected void enableEncryption(EncryptionInitInfo encryptionInitInfo) throws SQLException, IOException {
        XdrInputStream xdrIn = this.getXdrIn();
        XdrOutputStream xdrOut = this.getXdrOut();
        Encoding encoding = this.getEncoding();
        EncryptionIdentifier encryptionIdentifier = encryptionInitInfo.getEncryptionIdentifier();
        xdrOut.writeInt(96);
        xdrOut.writeString(encryptionIdentifier.getPluginName(), encoding);
        xdrOut.writeString(encryptionIdentifier.getType(), encoding);
        xdrOut.flush();
        xdrIn.setCipher(encryptionInitInfo.getDecryptionCipher());
        xdrOut.setCipher(encryptionInitInfo.getEncryptionCipher());
        this.readOperationResponse(this.readNextOperation(), null);
    }

    protected final void handleCryptKeyCallback(DbCryptCallback dbCryptCallback) throws IOException, SQLException {
        DbCryptData clientPluginResponse;
        DbCryptData serverPluginData = this.readCryptKeyCallback();
        try {
            clientPluginResponse = dbCryptCallback.handleCallback(serverPluginData);
        }
        catch (Exception e) {
            log.error("Error during database encryption callback, using default empty response", e);
            clientPluginResponse = DbCryptData.EMPTY_DATA;
        }
        this.writeCryptKeyCallback(clientPluginResponse);
    }

    protected DbCryptData readCryptKeyCallback() throws IOException, SQLException {
        XdrInputStream xdrIn = this.getXdrIn();
        byte[] pluginData = xdrIn.readBuffer();
        try {
            return new DbCryptData(pluginData, Integer.MIN_VALUE);
        }
        catch (RuntimeException e) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248285).cause(e).toSQLException();
        }
    }

    protected void writeCryptKeyCallback(DbCryptData clientPluginResponse) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(97);
        xdrOut.writeBuffer(clientPluginResponse.getPluginData());
        xdrOut.flush();
    }
}

