/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.fields;

import java.util.Objects;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldValue;

public final class FieldDescriptor {
    private final int position;
    private final DatatypeCoder datatypeCoder;
    private final int type;
    private final int subType;
    private final int scale;
    private final int length;
    private final String fieldName;
    private final String tableAlias;
    private final String originalName;
    private final String originalTableName;
    private final String ownerName;
    private int hash;

    public FieldDescriptor(int position, DatatypeCoder datatypeCoder, int type, int subType, int scale, int length, String fieldName, String tableAlias, String originalName, String originalTableName, String ownerName) {
        assert (datatypeCoder != null) : "dataTypeCoder should not be null";
        this.position = position;
        this.datatypeCoder = datatypeCoder;
        this.type = type;
        this.subType = subType;
        this.scale = scale;
        this.length = length;
        this.fieldName = fieldName;
        this.tableAlias = tableAlias == null || !tableAlias.isEmpty() ? tableAlias : null;
        this.originalName = originalName;
        this.originalTableName = originalTableName;
        this.ownerName = ownerName;
    }

    public int getPosition() {
        return this.position;
    }

    public DatatypeCoder getDatatypeCoder() {
        return this.datatypeCoder;
    }

    public IEncodingFactory getEncodingFactory() {
        return this.datatypeCoder.getEncodingFactory();
    }

    public int getType() {
        return this.type;
    }

    public int getSubType() {
        return this.subType;
    }

    public int getScale() {
        return this.scale;
    }

    public int getLength() {
        return this.length;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getOriginalTableName() {
        return this.originalTableName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean isVarying() {
        return this.isFbType(448);
    }

    public boolean isFbType(int fbType) {
        return (this.getType() & 0xFFFFFFFE) == fbType;
    }

    public boolean isNullable() {
        return (this.getType() & 1) == 1;
    }

    public FieldValue createDefaultFieldValue() {
        return new FieldValue();
    }

    public boolean typeEquals(FieldDescriptor other) {
        return this == other || other != null && this.type == other.type && this.subType == other.subType && this.scale == other.scale && this.length == other.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendFieldDescriptor(sb);
        return sb.toString();
    }

    StringBuilder appendFieldDescriptor(StringBuilder sb) {
        sb.append("FieldDescriptor:[").append("Position=").append(this.getPosition()).append(",FieldName=").append(this.getFieldName()).append(",TableAlias=").append(this.getTableAlias()).append(",Type=").append(this.getType()).append(",SubType=").append(this.getSubType()).append(",Scale=").append(this.getScale()).append(",Length=").append(this.getLength()).append(",OriginalName=").append(this.getOriginalName()).append(",OriginalTableName=").append(this.getOriginalTableName()).append(",OwnerName=").append(this.getOwnerName()).append(']');
        return sb;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldDescriptor)) {
            return false;
        }
        FieldDescriptor other = (FieldDescriptor)obj;
        return this.position == other.position && this.type == other.type && this.subType == other.subType && this.scale == other.scale && this.length == other.length && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.tableAlias, other.tableAlias) && Objects.equals(this.originalName, other.originalName) && Objects.equals(this.originalTableName, other.originalTableName) && Objects.equals(this.ownerName, other.ownerName) && this.datatypeCoder == other.datatypeCoder;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.position, this.type, this.subType, this.scale, this.length, this.fieldName, this.tableAlias, this.originalName, this.originalTableName, this.ownerName);
        }
        return this.hash;
    }
}

