/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.FbAttachment;
import org.firebirdsql.gds.ng.IAttachProperties;

public abstract class AbstractConnection<T extends IAttachProperties<T>, C extends FbAttachment> {
    protected final T attachProperties;
    private final EncodingDefinition encodingDefinition;
    private final IEncodingFactory encodingFactory;

    protected AbstractConnection(T attachProperties, IEncodingFactory encodingFactory) throws SQLException {
        this.attachProperties = attachProperties.asNewMutable();
        String firebirdEncodingName = attachProperties.getEncoding();
        String javaCharsetAlias = attachProperties.getCharSet();
        EncodingDefinition tempEncodingDefinition = encodingFactory.getEncodingDefinition(firebirdEncodingName, javaCharsetAlias);
        if (tempEncodingDefinition == null || tempEncodingDefinition.isInformationOnly()) {
            if (firebirdEncodingName == null && javaCharsetAlias == null) {
                tempEncodingDefinition = encodingFactory.getEncodingDefinition("NONE", null);
            } else {
                throw new SQLNonTransientConnectionException(String.format("No valid encoding definition for Firebird encoding %s and/or Java charset %s", firebirdEncodingName, javaCharsetAlias), "08000");
            }
        }
        this.encodingDefinition = tempEncodingDefinition;
        this.encodingFactory = encodingFactory.withDefaultEncodingDefinition(this.encodingDefinition);
    }

    public abstract C identify() throws SQLException;

    public final String getServerName() {
        return this.attachProperties.getServerName();
    }

    public final int getPortNumber() {
        return this.attachProperties.getPortNumber();
    }

    public final String getAttachObjectName() {
        return this.attachProperties.getAttachObjectName();
    }

    public final T getAttachProperties() {
        return this.attachProperties.asImmutable();
    }

    public final EncodingDefinition getEncodingDefinition() {
        return this.encodingDefinition;
    }

    public final Encoding getEncoding() {
        return this.encodingDefinition.getEncoding();
    }

    public final IEncodingFactory getEncodingFactory() {
        return this.encodingFactory;
    }
}

