/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.nio.charset.Charset;
import org.firebirdsql.encodings.CharacterTranslator;
import org.firebirdsql.encodings.Encoding;

final class EncodingGeneric
implements Encoding {
    private final Charset charset;

    EncodingGeneric(Charset charset) {
        this.charset = charset;
    }

    @Override
    public byte[] encodeToCharset(String in) {
        return in.getBytes(this.charset);
    }

    @Override
    public String decodeFromCharset(byte[] in) {
        return new String(in, this.charset);
    }

    @Override
    public String decodeFromCharset(byte[] in, int offset, int length) {
        return new String(in, offset, length, this.charset);
    }

    @Override
    public Encoding withTranslation(CharacterTranslator translator) {
        if (translator == null) {
            return this;
        }
        return new EncodingGenericWithTranslation(translator);
    }

    @Override
    public String getCharsetName() {
        return this.charset.name();
    }

    private final class EncodingGenericWithTranslation
    implements Encoding {
        private final CharacterTranslator translator;

        private EncodingGenericWithTranslation(CharacterTranslator translator) {
            assert (translator != null) : "CharacterTranslator should never be null";
            this.translator = translator;
        }

        @Override
        public byte[] encodeToCharset(String in) {
            return EncodingGeneric.this.encodeToCharset(new String(this.translate(in.toCharArray())));
        }

        @Override
        public String decodeFromCharset(byte[] in) {
            String result = EncodingGeneric.this.decodeFromCharset(in);
            return new String(this.translate(result.toCharArray()));
        }

        @Override
        public String decodeFromCharset(byte[] in, int off, int len) {
            String result = EncodingGeneric.this.decodeFromCharset(in, off, len);
            return new String(this.translate(result.toCharArray()));
        }

        @Override
        public Encoding withTranslation(CharacterTranslator translator) {
            return EncodingGeneric.this.withTranslation(translator);
        }

        @Override
        public String getCharsetName() {
            return EncodingGeneric.this.charset.name();
        }

        private char[] translate(char[] chars) {
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.translator.getMapping(chars[i]);
            }
            return chars;
        }
    }
}

