/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.ff4j.FF4j;
import org.ff4j.web.FF4jProvider;
import org.ff4j.web.controller.AbstractController;
import org.ff4j.web.controller.AuditController;
import org.ff4j.web.controller.FeatureUsageController;
import org.ff4j.web.controller.FeaturesController;
import org.ff4j.web.controller.HomeController;
import org.ff4j.web.controller.InfosController;
import org.ff4j.web.controller.NotFoundController;
import org.ff4j.web.controller.OperationsController;
import org.ff4j.web.controller.PropertiesController;
import org.ff4j.web.controller.SettingsController;
import org.ff4j.web.controller.StaticResourceController;
import org.ff4j.web.controller.TimeSeriesController;
import org.ff4j.web.thymeleaf.CustomMessageResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class FF4jServlet
extends HttpServlet {
    private static final long serialVersionUID = 8447941463286918975L;
    public static final Logger LOGGER = LoggerFactory.getLogger(FF4jServlet.class);
    protected FF4j ff4j = null;
    protected FF4jProvider ff4jProvider = null;
    protected TemplateEngine templateEngine = null;
    protected StaticResourceController staticResourceController;
    protected OperationsController operationsController;
    protected static Map<String, AbstractController> mapOfControllers = new HashMap<String, AbstractController>();

    public void init(ServletConfig servletConfig) throws ServletException {
        LOGGER.info("  __  __ _  _   _ ");
        LOGGER.info(" / _|/ _| || | (_)");
        LOGGER.info("| |_| |_| || |_| |");
        LOGGER.info("|  _|  _|__   _| |");
        LOGGER.info("|_| |_|    |_|_/ |");
        LOGGER.info("             |__/  v" + ((Object)((Object)this)).getClass().getPackage().getImplementationVersion());
        LOGGER.info(" ");
        if (this.ff4j == null) {
            this.initializeFF4J(servletConfig);
        }
        this.initializeTemplateEngine();
        this.staticResourceController = new StaticResourceController(this.ff4j, this.templateEngine);
        this.operationsController = new OperationsController(this.ff4j, this.templateEngine);
        this.addController(new HomeController(this.ff4j, this.templateEngine));
        this.addController(new InfosController(this.ff4j, this.templateEngine));
        this.addController(new FeaturesController(this.ff4j, this.templateEngine));
        this.addController(new PropertiesController(this.ff4j, this.templateEngine));
        this.addController(new SettingsController(this.ff4j, this.templateEngine));
        this.addController(new NotFoundController(this.ff4j, this.templateEngine));
        this.addController(new AuditController(this.ff4j, this.templateEngine));
        this.addController(new FeatureUsageController(this.ff4j, this.templateEngine));
        this.addController(new TimeSeriesController(this.ff4j, this.templateEngine));
    }

    private void addController(AbstractController ac) {
        mapOfControllers.put(ac.getSuccessView(), ac);
    }

    private void initializeFF4J(ServletConfig servletConfig) {
        String className = servletConfig.getInitParameter("ff4jProvider");
        try {
            Class<?> c = Class.forName(className);
            Method method = c.getMethod("getInstance", new Class[0]);
            Object o = method.invoke(null, new Object[0]);
            this.ff4jProvider = (FF4jProvider)o;
            LOGGER.info("ff4j context has been successfully initialized - {} feature(s)", (Object)this.ff4jProvider.getFF4j().getFeatures().size());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot load ff4jProvider as " + this.ff4jProvider, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No static method getInstance in " + this.ff4jProvider, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to invoke getInstance in " + this.ff4jProvider, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("No public constructor for  " + this.ff4jProvider + " as ff4jProvider", e);
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("ff4jProvider expected instance of " + FF4jProvider.class, ce);
        }
        this.ff4j = this.ff4jProvider.getFF4j();
        servletConfig.getServletContext().setAttribute("FF4J", (Object)this.ff4j);
        LOGGER.debug("Servlet has been initialized and ff4j store in session with {} ", (Object)this.ff4j.getFeatures().size());
        String cssFile = servletConfig.getInitParameter("customCSS");
        if (cssFile != null) {
            LOGGER.debug("A custom CSS has been defined [" + cssFile + "]");
            servletConfig.getServletContext().setAttribute("customCSS", (Object)cssFile);
        }
    }

    private void initializeTemplateEngine() {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setTemplateMode(TemplateMode.HTML);
        templateResolver.setPrefix("views/view-");
        templateResolver.setSuffix(".html");
        templateResolver.setCacheTTLMs(Long.valueOf(3600000L));
        this.templateEngine = new TemplateEngine();
        this.templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        this.templateEngine.addMessageResolver((IMessageResolver)new CustomMessageResolver());
        LOGGER.info("Thymeleaf has been initialized");
    }

    public FF4j getFf4j() {
        if (this.ff4j == null) {
            throw new IllegalStateException("Console Servlet has not been initialized, please set 'load-at-startup' to 1");
        }
        return this.ff4j;
    }

    public void setFf4j(FF4j ff4j) {
        this.ff4j = ff4j;
    }
}

