/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.ff4j.FF4j;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureXmlParser;
import org.ff4j.web.AdministrationConsoleRenderer;
import org.ff4j.web.FF4jWebContextHolder;

public class AdministrationConsoleServlet
extends HttpServlet {
    private static final long serialVersionUID = -3982043895954284269L;
    private static final int BUFFER_SIZE = 4096;

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String message = null;
        String messagetype = "info";
        String operation = req.getParameter("op");
        try {
            if (operation != null && !operation.isEmpty()) {
                if ("disable".equalsIgnoreCase(operation)) {
                    this.opDisableFeature(req);
                    message = this.buildMessage(req.getParameter("uid"), "DISABLED");
                } else if ("enable".equalsIgnoreCase(operation)) {
                    this.opEnableFeature(req);
                    message = this.buildMessage(req.getParameter("uid"), "ENABLED");
                } else if ("editfp".equalsIgnoreCase(operation)) {
                    this.opUpdateFeatureDescription(req);
                    message = this.buildMessage(req.getParameter("uid"), "UPDATED");
                } else if ("addfp".equalsIgnoreCase(operation)) {
                    this.opAddNewFeature(req);
                    message = this.buildMessage(req.getParameter("uid"), "ADDED");
                } else if ("rmvfp".equalsIgnoreCase(operation)) {
                    this.opDeleteFeature(req);
                    message = this.buildMessage(req.getParameter("uid"), "DELETED");
                } else if ("addrole".equalsIgnoreCase(operation)) {
                    this.opAddRoleToFeature(req);
                    message = "Role <b>" + req.getParameter("role") + "</b> has been successfully added to flipPoint <b>" + req.getParameter("uid") + " </b>";
                } else if ("rmvrole".equalsIgnoreCase(operation)) {
                    this.opRemoveRoleFromFeature(req);
                    message = "Role <b>" + req.getParameter("role") + "</b> has been successfully removed from flipPoint <b>" + req.getParameter("uid") + " </b>";
                } else if ("export".equalsIgnoreCase(operation)) {
                    this.buildResponseForExportFeature(res);
                }
            }
        }
        catch (Exception e) {
            messagetype = "error";
            message = e.getMessage();
        }
        this.renderPage(req, res, message, messagetype);
    }

    private String buildMessage(String featureName, String operationId) {
        return String.format("Feature <b>%s</b> has been successfully %s", featureName, operationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildResponseForExportFeature(HttpServletResponse res) throws IOException {
        InputStream in = new FeatureXmlParser().exportFeatures(this.getFf4j().getStore().readAll());
        ServletOutputStream sos = null;
        try {
            sos = res.getOutputStream();
            res.setContentType("text/xml");
            res.setHeader("Content-Disposition", "attachment; filename=\"ff4j.xml\"");
            byte[] bbuf = new byte[4096];
            int length = 0;
            while (in != null && length != -1) {
                length = in.read(bbuf);
                sos.write(bbuf, 0, length);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (sos != null) {
                sos.flush();
                sos.close();
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String message = null;
        String messagetype = "error";
        try {
            List items = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(req);
            for (FileItem item : items) {
                if (item.isFormField()) {
                    if (!"op".equalsIgnoreCase(item.getFieldName())) continue;
                    continue;
                }
                if (!"flipFile".equalsIgnoreCase(item.getFieldName())) continue;
                String filename = FilenameUtils.getName((String)item.getName());
                if (filename.toLowerCase().endsWith("xml")) {
                    this.opImportFile(item.getInputStream());
                    continue;
                }
                messagetype = "error";
                message = "Invalid FILE, must be CSV, XML or PROPERTIES files";
            }
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        this.renderPage(req, res, message, messagetype);
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse res, String message, String messagetype) throws IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        out.println("<!DOCTYPE HTML \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n<html lang=\"en\">\n<head>\n <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" /> <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n <title>Features Flags 4 Java</title>\n <link href=\"css/bootstrap.css\"    rel=\"stylesheet\">\n <link href=\"css/DT_bootstrap.css\" rel=\"stylesheet\">\n <script type=\"text/javascript\" charset=\"utf-8\" language=\"javascript\" src=\"js/jquery.js\"></script>\n <script type=\"text/javascript\" charset=\"utf-8\" language=\"javascript\" src=\"js/jquery.dataTables.js\"></script>\n <script type=\"text/javascript\" charset=\"utf-8\" language=\"javascript\" src=\"js/DT_bootstrap.js\"></script>\n <script src=\"js/bootstrap-transition.js\"></script>\n <script src=\"js/bootstrap-alert.js\"></script>\n <script src=\"js/bootstrap-modal.js\"></script>\n <script src=\"js/bootstrap-dropdown.js\"></script>\n <script src=\"js/bootstrap-scrollspy.js\"></script>\n <script src=\"js/bootstrap-button.js\"></script>\n</head>\n<body style=\"background-color:white\">");
        out.println(AdministrationConsoleRenderer.renderNavBar(req));
        out.println("<div class=\"container\">");
        out.print(this.renderSectionFeatures(req, message, messagetype));
        out.println(AdministrationConsoleRenderer.renderModalEditFlip(req));
        out.println(AdministrationConsoleRenderer.renderModalNewFlipPoint(req));
        out.println(AdministrationConsoleRenderer.renderModalImportFlipPoints(req));
        out.println("</body>");
        out.println("</html>");
    }

    private void opEnableFeature(HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        if (featureId != null && !featureId.isEmpty()) {
            this.getFf4j().enable(featureId);
        }
    }

    private void opDisableFeature(HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        if (featureId != null && !featureId.isEmpty()) {
            this.getFf4j().disable(featureId);
        }
    }

    private void opAddNewFeature(HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        String featureDesc = req.getParameter("desc");
        if (featureId != null && !featureId.isEmpty()) {
            Feature fp = new Feature(featureId, false, featureDesc);
            this.getFf4j().getStore().create(fp);
        }
    }

    private void opDeleteFeature(HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        if (featureId != null && !featureId.isEmpty()) {
            this.getFf4j().getStore().delete(featureId);
        }
    }

    private void opUpdateFeatureDescription(HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        String description = req.getParameter("desc");
        if (featureId != null && !featureId.isEmpty()) {
            Feature fp = this.getFf4j().getStore().read(featureId);
            fp.setDescription(description);
            this.getFf4j().getStore().update(fp);
        }
    }

    private void opAddRoleToFeature(HttpServletRequest req) {
        String flipId = req.getParameter("uid");
        String roleName = req.getParameter("role");
        this.getFf4j().getStore().grantRoleOnFeature(flipId, roleName);
    }

    private void opRemoveRoleFromFeature(HttpServletRequest req) {
        String flipId = req.getParameter("uid");
        String roleName = req.getParameter("role");
        this.getFf4j().getStore().removeRoleFromFeature(flipId, roleName);
    }

    private void opImportFile(InputStream in) throws IOException {
        Map mapsOfFeat = new FeatureXmlParser().parseConfigurationFile(in);
        for (Map.Entry feature : mapsOfFeat.entrySet()) {
            if (this.getFf4j().getStore().exist((String)feature.getKey())) {
                this.getFf4j().getStore().update((Feature)feature.getValue());
                continue;
            }
            this.getFf4j().getStore().create((Feature)feature.getValue());
        }
    }

    private String renderSectionFeatures(HttpServletRequest req, String message, String type) {
        LinkedHashMap mapOfFlipPoints = new LinkedHashMap();
        if (this.getFf4j().getFeatures() != null && !this.getFf4j().getFeatures().isEmpty()) {
            mapOfFlipPoints.putAll(this.getFf4j().getFeatures());
        }
        StringBuilder strB = new StringBuilder(AdministrationConsoleRenderer.renderButtonsMainGroup(req));
        if (message != null && !message.isEmpty()) {
            strB.append(AdministrationConsoleRenderer.renderMessageBox(message, type));
        }
        strB.append("<div class=\"container\" style=\"padding:10px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"table table-striped table-bordered table-condensed\" id=\"example\"><thead> <tr><th>Feature</th><th style=\"width:100px;text-align:center\">Group</th><th style=\"width:350px;text-align:center\">Description</th><th style=\"width:80px;text-align:center\">Status</th><th style=\"width:20px;text-align:center\">E</th><th style=\"width:20px;text-align:center\">D</th><th style=\"width:65px;text-align:center\">&nbsp;Roles</th></tr></thead><tbody>");
        for (Feature fp : mapOfFlipPoints.values()) {
            strB.append("<tr>");
            strB.append("<td style=\"width:150px;font-weight:bold\">" + fp.getUid() + "</td>");
            if (fp.getGroup() != null) {
                strB.append("<td style=\"width:100px;\">" + fp.getGroup() + "</td>");
            } else {
                strB.append("<td style=\"width:100px;\"></td>");
            }
            if (fp.getDescription() != null) {
                strB.append("<td style=\"width:200px;\">" + fp.getDescription() + "</td>");
            } else {
                strB.append("<td style=\"width:200px;\"></td>");
            }
            strB.append("<td>");
            LinkedHashMap<String, String> mapP = new LinkedHashMap<String, String>();
            mapP.put("uid", fp.getUid());
            if (fp.isEnable()) {
                strB.append(AdministrationConsoleRenderer.renderElementButton(req, "Enabled", "success", "disable", mapP, null));
            } else {
                strB.append(AdministrationConsoleRenderer.renderElementButton(req, "Disabled", "danger", "enable", mapP, null));
            }
            strB.append("</td>");
            strB.append("<td style=\"width:20px;\">" + AdministrationConsoleRenderer.renderButtonEditFeature(this.getFf4j(), req, fp.getUid()) + "</td>");
            strB.append("<td style=\"width:20px;\">" + AdministrationConsoleRenderer.renderButtonDeleteFeature(req, fp.getUid()) + "</td>");
            strB.append("<td style=\"width:85px;\">");
            if (this.getFf4j().getAuthorizationsManager() != null) {
                strB.append(AdministrationConsoleRenderer.renderButtonUserRole(this.getFf4j(), req, fp));
            } else {
                strB.append("<center><span style=\"color:#AAAAAA\">N/A</span></center>");
            }
            strB.append("</td>");
            strB.append("</tr>");
        }
        strB.append(MessageFormat.format("</tbody></table></form></fieldset>", req.getContextPath() + req.getServletPath()));
        return strB.toString();
    }

    public FF4j getFf4j() {
        return FF4jWebContextHolder.getFf4j();
    }
}

