/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store.rowmapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.store.JdbcStoreConstants;
import org.ff4j.utils.ParameterUtils;
import org.springframework.jdbc.core.RowMapper;

public class FeatureRowMapper
implements RowMapper<Feature>,
JdbcStoreConstants {
    public Feature mapRow(ResultSet rs, int rowNum) throws SQLException {
        String featUid = rs.getString("FEAT_UID");
        Feature f = new Feature(featUid, rs.getInt("ENABLE") > 0);
        f.setDescription(rs.getString("DESCRIPTION"));
        f.setGroup(rs.getString("GROUPNAME"));
        String strategy = rs.getString("STRATEGY");
        if (strategy != null && !"".equals(strategy)) {
            try {
                FlippingStrategy flipStrategy = (FlippingStrategy)Class.forName(strategy).newInstance();
                flipStrategy.init(featUid, ParameterUtils.toMap((String)rs.getString("EXPRESSION")));
                f.setFlippingStrategy(flipStrategy);
            }
            catch (InstantiationException ie) {
                throw new FeatureAccessException("Cannot instantiate Strategy, no default constructor available", (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new FeatureAccessException("Cannot instantiate Strategy, no visible constructor", (Throwable)iae);
            }
            catch (ClassNotFoundException e) {
                throw new FeatureAccessException("Cannot instantiate Strategy, classNotFound", (Throwable)e);
            }
        }
        return f;
    }
}

