/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.property.AbstractProperty;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.store.JdbcStoreConstants;
import org.ff4j.store.rowmapper.CustomPropertyRowMapper;
import org.ff4j.store.rowmapper.FeatureRowMapper;
import org.ff4j.store.rowmapper.RoleRowMapper;
import org.ff4j.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FeatureStoreSpringJDBC
extends AbstractFeatureStore
implements JdbcStoreConstants {
    private static final FeatureRowMapper MAPPER = new FeatureRowMapper();
    private static final CustomPropertyRowMapper JDBC_PROPERTY_MAPPER = new CustomPropertyRowMapper();
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;

    public void enable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getJdbcTemplate().update("UPDATE FF4J_FEATURES SET ENABLE = 1 WHERE FEAT_UID = ?", new Object[]{uid});
    }

    public void disable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getJdbcTemplate().update("UPDATE FF4J_FEATURES SET ENABLE = 0 WHERE FEAT_UID = ?", new Object[]{uid});
    }

    public boolean exist(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        int count = (Integer)this.getJdbcTemplate().queryForObject("SELECT COUNT(FEAT_UID) FROM FF4J_FEATURES WHERE FEAT_UID = ?", Integer.class, new Object[]{uid});
        return 1 == count;
    }

    public Feature read(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        List dbFlips = this.getJdbcTemplate().query("SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES WHERE FEAT_UID = ?", (RowMapper)MAPPER, new Object[]{uid});
        if (dbFlips.isEmpty()) {
            throw new FeatureNotFoundException(uid);
        }
        Feature fp = (Feature)dbFlips.get(0);
        List customProperties = this.getJdbcTemplate().query("SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,DESCRIPTION,FIXEDVALUES,FEAT_UID FROM FF4J_CUSTOM_PROPERTIES WHERE FEAT_UID = ?", (RowMapper)JDBC_PROPERTY_MAPPER, new Object[]{uid});
        for (AbstractProperty ap : customProperties) {
            fp.getCustomProperties().put(ap.getName(), ap);
        }
        List auths = this.getJdbcTemplate().query("SELECT ROLE_NAME FROM FF4J_ROLES WHERE FEAT_UID = ?", (RowMapper)new SingleColumnRowMapper(), new Object[]{uid});
        fp.getPermissions().addAll(auths);
        return fp;
    }

    @Transactional
    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        String strategyColumn = null;
        String expressionColumn = null;
        if (fp.getFlippingStrategy() != null) {
            strategyColumn = fp.getFlippingStrategy().getClass().getCanonicalName();
            expressionColumn = ParameterUtils.fromMap((Map)fp.getFlippingStrategy().getInitParams());
        }
        this.getJdbcTemplate().update("INSERT INTO FF4J_FEATURES(FEAT_UID, ENABLE, DESCRIPTION, STRATEGY,EXPRESSION, GROUPNAME) VALUES(?, ?, ?, ?, ?, ?)", new Object[]{fp.getUid(), fp.isEnable() ? 1 : 0, fp.getDescription(), strategyColumn, expressionColumn, fp.getGroup()});
        if (fp.getPermissions() != null) {
            for (String role : fp.getPermissions()) {
                this.getJdbcTemplate().update("INSERT INTO FF4J_ROLES(FEAT_UID, ROLE_NAME) VALUES (?,?)", new Object[]{fp.getUid(), role});
            }
        }
    }

    @Transactional
    public void delete(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        Feature fp = this.read(uid);
        if (fp.getPermissions() != null) {
            for (String role : fp.getPermissions()) {
                this.getJdbcTemplate().update("DELETE FROM FF4J_ROLES WHERE FEAT_UID = ? AND ROLE_NAME = ?", new Object[]{fp.getUid(), role});
            }
        }
        if (fp.getCustomProperties() != null) {
            this.getJdbcTemplate().update("DELETE FROM FF4J_CUSTOM_PROPERTIES WHERE FEAT_UID = ?", new Object[]{fp.getUid()});
        }
        this.getJdbcTemplate().update("DELETE FROM FF4J_FEATURES WHERE FEAT_UID = ?", new Object[]{fp.getUid()});
    }

    @Transactional
    public void grantRoleOnFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getJdbcTemplate().update("INSERT INTO FF4J_ROLES(FEAT_UID, ROLE_NAME) VALUES (?,?)", new Object[]{uid, roleName});
    }

    @Transactional
    public void removeRoleFromFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getJdbcTemplate().update("DELETE FROM FF4J_ROLES WHERE FEAT_UID = ? AND ROLE_NAME = ?", new Object[]{uid, roleName});
    }

    @Transactional
    public void enableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        this.getJdbcTemplate().update("UPDATE FF4J_FEATURES SET ENABLE = 1 WHERE GROUPNAME = ?", new Object[]{groupName});
    }

    @Transactional
    public void disableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        this.getJdbcTemplate().update("UPDATE FF4J_FEATURES SET ENABLE = 0 WHERE GROUPNAME = ?", new Object[]{groupName});
    }

    public boolean existGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        int count = (Integer)this.getJdbcTemplate().queryForObject("SELECT COUNT(*) FROM FF4J_FEATURES WHERE GROUPNAME = ?", Integer.class, new Object[]{groupName});
        return count > 0;
    }

    public Map<String, Feature> readGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        List lFp = this.getJdbcTemplate().query("SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES WHERE GROUPNAME = ?", (RowMapper)MAPPER, new Object[]{groupName});
        for (Feature flipPoint : lFp) {
            mapFP.put(flipPoint.getUid(), flipPoint);
        }
        return mapFP;
    }

    @Transactional
    public void addToGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getJdbcTemplate().update("UPDATE FF4J_FEATURES SET GROUPNAME = ? WHERE FEAT_UID = ?", new Object[]{groupName, uid});
    }

    @Transactional
    public void removeFromGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        this.getJdbcTemplate().update("UPDATE FF4J_FEATURES SET GROUPNAME = ? WHERE FEAT_UID = ?", new Object[]{"", uid});
    }

    public Map<String, Feature> readAll() {
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        List lFp = this.getJdbcTemplate().query("SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES", (RowMapper)MAPPER);
        for (Feature flipPoint : lFp) {
            mapFP.put(flipPoint.getUid(), flipPoint);
        }
        RoleRowMapper rrm = new RoleRowMapper();
        this.getJdbcTemplate().query("SELECT FEAT_UID,ROLE_NAME FROM FF4J_ROLES", (RowMapper)rrm);
        Map<String, Set<String>> roles = rrm.getRoles();
        for (String featId : roles.keySet()) {
            if (!mapFP.containsKey(featId)) continue;
            mapFP.get(featId).getPermissions().addAll((Collection)roles.get(featId));
        }
        return mapFP;
    }

    public Set<String> readAllGroups() {
        HashSet<String> setOfGroup = new HashSet<String>();
        setOfGroup.addAll(this.getJdbcTemplate().query("SELECT DISTINCT(GROUPNAME) FROM FF4J_FEATURES", (RowMapper)new SingleColumnRowMapper()));
        setOfGroup.remove(null);
        setOfGroup.remove("");
        return setOfGroup;
    }

    @Transactional
    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        Feature fpExist = this.read(fp.getUid());
        String fStrategy = null;
        String fExpression = null;
        if (fp.getFlippingStrategy() != null) {
            fStrategy = fp.getFlippingStrategy().getClass().getCanonicalName();
            fExpression = ParameterUtils.fromMap((Map)fp.getFlippingStrategy().getInitParams());
        }
        String enable = "0";
        if (fp.isEnable()) {
            enable = "1";
        }
        this.getJdbcTemplate().update("UPDATE FF4J_FEATURES SET ENABLE=?,DESCRIPTION=?,STRATEGY=?,EXPRESSION=?,GROUPNAME=? WHERE FEAT_UID = ?", new Object[]{enable, fp.getDescription(), fStrategy, fExpression, fp.getGroup(), fp.getUid()});
        HashSet toBeDeleted = new HashSet();
        toBeDeleted.addAll(fpExist.getPermissions());
        toBeDeleted.removeAll(fp.getPermissions());
        for (String roleToBeDelete : toBeDeleted) {
            this.removeRoleFromFeature(fpExist.getUid(), roleToBeDelete);
        }
        HashSet toBeAdded = new HashSet();
        toBeAdded.addAll(fp.getPermissions());
        toBeAdded.removeAll(fpExist.getPermissions());
        for (String addee : toBeAdded) {
            this.grantRoleOnFeature(fpExist.getUid(), addee);
        }
        if (fp.isEnable() != fpExist.isEnable()) {
            if (fp.isEnable()) {
                this.enable(fp.getUid());
            } else {
                this.disable(fp.getUid());
            }
        }
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"type\":\"" + ((Object)((Object)this)).getClass().getCanonicalName() + "\"");
        sb.append("\"datasource\":\"" + this.dataSource.getClass() + "\"");
        Set<String> myFeatures = this.readAll().keySet();
        sb.append(",\"numberOfFeatures\":" + myFeatures.size());
        sb.append(",\"cached\":" + this.isCached());
        if (this.isCached()) {
            sb.append(",\"cacheProvider\":\"" + this.getCacheProvider() + "\"");
            sb.append(",\"cacheStore\":\"" + this.getCachedTargetStore() + "\"");
        }
        sb.append(",\"features\":[");
        boolean first = true;
        for (String myFeature : myFeatures) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myFeature + "\"");
        }
        Set<String> myGroups = this.readAllGroups();
        sb.append("],\"numberOfGroups\":" + myGroups.size());
        sb.append(",\"groups\":[");
        first = true;
        for (String myGroup : myGroups) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myGroup + "\"");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    public JdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            if (this.dataSource == null) {
                throw new IllegalStateException("ff4j-jdbc: DatabaseStore has not been properly initialized, datasource is null");
            }
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
        return this.jdbcTemplate;
    }

    public boolean isCached() {
        return false;
    }

    public String getCacheProvider() {
        return null;
    }

    public String getCachedTargetStore() {
        return null;
    }
}

