/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.core.Feature;
import org.ff4j.property.Property;
import org.ff4j.redis.RedisConnection;
import org.ff4j.redis.RedisContants;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.FeatureJsonParser;
import org.ff4j.utils.json.PropertyJsonParser;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class FF4jCacheManagerRedis
implements FF4JCacheManager {
    private RedisConnection redisConnection;
    protected int timeToLive = RedisContants.DEFAULT_TTL;

    public FF4jCacheManagerRedis(RedisConnection redisConn) {
        this.redisConnection = redisConn;
    }

    public FF4jCacheManagerRedis() {
        this(new RedisConnection());
    }

    public FF4jCacheManagerRedis(String host, int port) {
        this.redisConnection = new RedisConnection(host, port);
    }

    public Set<String> listCachedFeatureNames() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set<String> set = this.getKeys(jedis, "FF4J_FEATURE_*");
            return set;
        }
    }

    public String getCacheProviderName() {
        return "REDIS";
    }

    public void clearFeatures() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set<String> matchingKeys = this.getKeys(jedis, "FF4J_FEATURE_*");
            if (!matchingKeys.isEmpty()) {
                jedis.del(matchingKeys.toArray(new String[matchingKeys.size()]));
            }
        }
    }

    private Set<String> getKeys(Jedis jedis, String pattern) {
        HashSet<String> matchingKeys = new HashSet<String>();
        ScanParams params = new ScanParams();
        params.match(pattern);
        String cursor = "0";
        do {
            ScanResult scanResult = jedis.scan(cursor, params);
            List keys = scanResult.getResult();
            cursor = scanResult.getCursor();
            matchingKeys.addAll(keys);
        } while (!cursor.equals("0"));
        return matchingKeys;
    }

    public void clearProperties() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.del("FF4J_PROPERTY_*");
        }
    }

    public void evictFeature(String uid) {
        Util.assertParamHasLength((String)uid, (String)" feature identifier");
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.del("FF4J_FEATURE_" + uid);
        }
    }

    public void evictProperty(String propertyName) {
        Util.assertParamHasLength((String)propertyName, (String)" property name");
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("PropertyName cannot be null nor empty");
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.del("FF4J_PROPERTY_" + propertyName);
        }
    }

    public void putFeature(Feature fp) {
        Util.assertNotNull((Object[])new Object[]{fp});
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.set("FF4J_FEATURE_" + fp.getUid(), fp.toJson());
            jedis.expire("FF4J_FEATURE_" + fp.getUid(), this.getTimeToLive());
        }
    }

    public void putProperty(Property<?> property) {
        Util.assertNotNull((Object[])new Object[]{property});
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.set("FF4J_PROPERTY_" + property.getName(), property.toJson());
            jedis.expire("FF4J_PROPERTY_" + property.getName(), this.getTimeToLive());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature getFeature(String uid) {
        Util.assertParamHasLength((String)uid, (String)"feature uid");
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            String value = jedis.get("FF4J_FEATURE_" + uid);
            if (value != null) {
                Feature feature = FeatureJsonParser.parseFeature((String)value);
                return feature;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property<?> getProperty(String propertyName) {
        Util.assertParamHasLength((String)propertyName, (String)"property name");
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            String value = jedis.get("FF4J_PROPERTY_" + propertyName);
            if (value != null) {
                Property property = PropertyJsonParser.parseProperty((String)value);
                return property;
            }
        }
        return null;
    }

    public Set<String> listCachedPropertyNames() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set set = jedis.keys("FF4J_PROPERTY_*");
            return set;
        }
    }

    public Object getFeatureNativeCache() {
        return this.getJedis();
    }

    public Object getPropertyNativeCache() {
        return this.getJedis();
    }

    public Jedis getJedis() {
        Util.assertNotNull((Object[])new Object[]{this.redisConnection});
        Jedis jedis = this.redisConnection.getJedis();
        if (jedis == null) {
            throw new IllegalArgumentException("Cannot found any jedis connection, please build connection");
        }
        return jedis;
    }

    public RedisConnection getRedisConnection() {
        return this.redisConnection;
    }

    public void setRedisConnection(RedisConnection redisConnection) {
        this.redisConnection = redisConnection;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }
}

