/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import org.ff4j.cache.FeatureCacheManager;
import org.ff4j.core.Feature;
import org.ff4j.utils.FeatureJsonMarshaller;
import redis.clients.jedis.Jedis;

public class FeatureCacheProviderRedis
implements FeatureCacheManager {
    public static final String DEFAULT_REDIS_HOST = "localhost";
    public static final int DEFAULT_REDIS_PORT = 6379;
    public static final int DEFAULT_TTL = 900000000;
    private final String redisHost = "localhost";
    private final int redisport = 6379;
    private final int timeToLive = 900000000;
    private final Jedis jedis = new Jedis("localhost", 6379);

    public FeatureCacheProviderRedis() {
    }

    public FeatureCacheProviderRedis(String host, int port) {
    }

    public void clear() {
        this.jedis.flushAll();
    }

    public void evict(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        this.jedis.del(uid);
    }

    public void put(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        this.jedis.set(fp.getUid(), fp.toString());
        this.jedis.expire(fp.getUid(), 900000000);
    }

    public Feature get(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        String value = this.jedis.get(uid);
        if (value != null) {
            return FeatureJsonMarshaller.unMarshallFeature((String)value);
        }
        return null;
    }

    public Object getNativeCache() {
        return this.jedis;
    }

    public String getRedisHost() {
        return DEFAULT_REDIS_HOST;
    }

    public int getRedisport() {
        return 6379;
    }

    public int getTimeToLive() {
        return 900000000;
    }
}

