/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.autoconfigure;

import javax.servlet.Servlet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.FF4j;
import org.ff4j.spring.boot.autoconfigure.FF4JConfiguration;
import org.ff4j.spring.boot.autoconfigure.FF4JConfigurationProperties;
import org.ff4j.web.FF4jDispatcherServlet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={FF4jDispatcherServlet.class})
@AutoConfigureAfter(value={FF4JConfiguration.class})
@ConditionalOnProperty(value={"ff4j.web-console.enabled"}, havingValue="true", matchIfMissing=false)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/ff4j/spring/boot/autoconfigure/FF4JWebConsoleConfiguration;", "Lorg/springframework/boot/web/servlet/support/SpringBootServletInitializer;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "config", "Lorg/ff4j/spring/boot/autoconfigure/FF4JConfigurationProperties;", "(Lorg/ff4j/spring/boot/autoconfigure/FF4JConfigurationProperties;)V", "log", "Lorg/slf4j/Logger;", "ff4jDispatcherServletRegistrationBean", "Lorg/springframework/boot/web/servlet/ServletRegistrationBean;", "ff4jDispatcherServlet", "Lorg/ff4j/web/FF4jDispatcherServlet;", "getFF4jDispatcherServlet", "ff4j", "Lorg/ff4j/FF4j;", "ff4j-spring-boot-autoconfigure"})
public class FF4JWebConsoleConfiguration
extends SpringBootServletInitializer
implements WebMvcConfigurer {
    @NotNull
    private final FF4JConfigurationProperties config;
    @NotNull
    private final Logger log;

    public FF4JWebConsoleConfiguration(@NotNull FF4JConfigurationProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        Logger logger = LoggerFactory.getLogger(FF4JWebConsoleConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(FF4JWebConsoleConfiguration::class.java)");
        this.log = logger;
    }

    @Bean
    @ConditionalOnMissingBean
    @Nullable
    public FF4jDispatcherServlet getFF4jDispatcherServlet(@NotNull FF4j ff4j) {
        Intrinsics.checkNotNullParameter((Object)ff4j, (String)"ff4j");
        this.log.info("Initializing the web console servlet");
        FF4jDispatcherServlet ff4jConsoleServlet = new FF4jDispatcherServlet();
        ff4jConsoleServlet.setFf4j(ff4j);
        return ff4jConsoleServlet;
    }

    @Bean
    @NotNull
    public ServletRegistrationBean<?> ff4jDispatcherServletRegistrationBean(@NotNull FF4jDispatcherServlet ff4jDispatcherServlet) {
        Intrinsics.checkNotNullParameter((Object)ff4jDispatcherServlet, (String)"ff4jDispatcherServlet");
        this.log.info("Exposing FF4j web console on path '{}' ", (Object)this.config.getWebConsole().getContextPath());
        String[] stringArray = new String[]{this.config.getWebConsole().getContextPath() + "/*"};
        return new ServletRegistrationBean((Servlet)ff4jDispatcherServlet, stringArray);
    }
}

