/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.autoconfigure;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.spring.boot.autoconfigure.FF4JConfigurationProperties;
import org.ff4j.spring.boot.autoconfigure.FF4JWebConsoleConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.UserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@ConditionalOnProperty(value={"ff4j.web-console.security.enabled"}, havingValue="true", matchIfMissing=false)
@ConditionalOnBean(value={FF4JWebConsoleConfiguration.class})
@AutoConfigureAfter(value={FF4JWebConsoleConfiguration.class})
@EnableWebSecurity
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/ff4j/spring/boot/autoconfigure/FF4JSecurityConfiguration;", "Lorg/springframework/security/config/annotation/web/configuration/WebSecurityConfigurerAdapter;", "config", "Lorg/ff4j/spring/boot/autoconfigure/FF4JConfigurationProperties;", "(Lorg/ff4j/spring/boot/autoconfigure/FF4JConfigurationProperties;)V", "configure", "", "auth", "Lorg/springframework/security/config/annotation/authentication/builders/AuthenticationManagerBuilder;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "ff4j-spring-boot-autoconfigure"})
public class FF4JSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @NotNull
    private final FF4JConfigurationProperties config;

    public FF4JSecurityConfiguration(@NotNull FF4JConfigurationProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    protected void configure(@Nullable AuthenticationManagerBuilder auth) {
        block0: {
            UserDetailsManagerConfigurer.UserDetailsBuilder userDetailsBuilder;
            UserDetailsManagerConfigurer.UserDetailsBuilder userDetailsBuilder2;
            InMemoryUserDetailsManagerConfigurer inMemoryUserDetailsManagerConfigurer;
            PasswordEncoder encoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
            if (auth == null || (inMemoryUserDetailsManagerConfigurer = auth.inMemoryAuthentication()) == null || (userDetailsBuilder2 = inMemoryUserDetailsManagerConfigurer.withUser(this.config.getWebConsole().getSecurity().getUsername())) == null || (userDetailsBuilder = userDetailsBuilder2.password(encoder.encode((CharSequence)this.config.getWebConsole().getSecurity().getPassword()))) == null) break block0;
            String[] stringArray = new String[]{"ADMIN"};
            userDetailsBuilder.roles(stringArray);
        }
    }

    protected void configure(@Nullable HttpSecurity http) {
        block0: {
            HttpSecurity httpSecurity = http;
            if (httpSecurity == null || (httpSecurity = httpSecurity.csrf()) == null || (httpSecurity = (HttpSecurity)httpSecurity.disable()) == null || (httpSecurity = httpSecurity.authorizeRequests()) == null || (httpSecurity = (ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)httpSecurity.anyRequest()) == null) break block0;
            httpSecurity.permitAll();
        }
    }
}

