/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.placeholder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ff4j.FF4j;
import org.ff4j.spring.placeholder.PropertiesPlaceHolderBeanDefinitionVisitor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

public class FF4jPropertiesPlaceHolderConfigurer
implements BeanFactoryPostProcessor,
BeanFactoryAware,
Ordered,
BeanNameAware {
    private static final Log LOGGER = LogFactory.getLog(FF4jPropertiesPlaceHolderConfigurer.class);
    private String id;
    private int order;
    private FF4j ff4j;
    private String beanName;
    private BeanFactory beanFactory;

    public final void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        try {
            PropertiesPlaceHolderBeanDefinitionVisitor visitor = new PropertiesPlaceHolderBeanDefinitionVisitor(this.ff4j);
            String[] beanNames = beanFactory.getBeanDefinitionNames();
            for (int i = 0; i < beanNames.length; ++i) {
                if (beanNames[i].equals(this.beanName) && beanFactory.equals(beanFactory)) continue;
                BeanDefinition bd = beanFactory.getBeanDefinition(beanNames[i]);
                try {
                    visitor.visitBeanDefinition(bd);
                    continue;
                }
                catch (BeanDefinitionStoreException ex) {
                    throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanNames[i], ex.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot handle placeholding through ff4j : ", (Throwable)e);
            throw new BeanInitializationException("An error occured during substition", (Throwable)e);
        }
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanFactory(BeanFactory arg0) throws BeansException {
        this.beanFactory = arg0;
    }

    public FF4j getFf4j() {
        return this.ff4j;
    }

    public void setFf4j(FF4j ff4j) {
        this.ff4j = ff4j;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

