/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.index.reindex.AbstractAsyncBulkByScrollAction;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.TransportDeleteByQueryAction;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;

public class AsyncDeleteByQueryAction
extends AbstractAsyncBulkByScrollAction<DeleteByQueryRequest, TransportDeleteByQueryAction> {
    private final boolean useSeqNoForCAS;

    public AsyncDeleteByQueryAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, TransportDeleteByQueryAction action, DeleteByQueryRequest request, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
        super(task, !clusterState.nodes().getMinNodeVersion().onOrAfter(Version.V_6_7_0), clusterState.nodes().getMinNodeVersion().onOrAfter(Version.V_6_7_0), logger, client, threadPool, action, request, listener);
        this.useSeqNoForCAS = clusterState.nodes().getMinNodeVersion().onOrAfter(Version.V_6_7_0);
    }

    @Override
    protected boolean accept(ScrollableHitSource.Hit doc) {
        return true;
    }

    @Override
    protected AbstractAsyncBulkByScrollAction.RequestWrapper<DeleteRequest> buildRequest(ScrollableHitSource.Hit doc) {
        DeleteRequest delete = new DeleteRequest();
        delete.index(doc.getIndex());
        delete.type(doc.getType());
        delete.id(doc.getId());
        if (this.useSeqNoForCAS) {
            delete.setIfSeqNo(doc.getSeqNo());
            delete.setIfPrimaryTerm(doc.getPrimaryTerm());
        } else {
            delete.version(doc.getVersion());
        }
        return AsyncDeleteByQueryAction.wrap(delete);
    }

    @Override
    protected AbstractAsyncBulkByScrollAction.RequestWrapper<?> copyMetadata(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
        request.setParent(doc.getParent());
        request.setRouting(doc.getRouting());
        return request;
    }
}

