/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.aggregations;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.join.aggregations.InternalChildren;
import org.elasticsearch.join.aggregations.ParentToChildrenAggregator;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class ChildrenAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final Query parentFilter;
    private final Query childFilter;

    public ChildrenAggregatorFactory(String name, ValuesSourceConfig config, Query childFilter, Query parentFilter, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.childFilter = childFilter;
        this.parentFilter = parentFilter;
    }

    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new NonCollectingAggregator(this.name, this.context, parent, this.factories, metadata){

            public InternalAggregation buildEmptyAggregation() {
                return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
            }
        };
    }

    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        ValuesSource rawValuesSource = this.config.getValuesSource();
        if (!(rawValuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
            throw new AggregationExecutionException("ValuesSource type " + rawValuesSource.toString() + "is not supported for aggregation " + this.name());
        }
        ValuesSource.Bytes.WithOrdinals valuesSource = (ValuesSource.Bytes.WithOrdinals)rawValuesSource;
        long maxOrd = valuesSource.globalMaxOrd(this.context.searcher());
        return new ParentToChildrenAggregator(this.name, this.factories, this.context, parent, this.childFilter, this.parentFilter, valuesSource, maxOrd, cardinality, metadata);
    }

    public String getStatsSubtype() {
        return "other";
    }
}

