/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.aggregations;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public abstract class ParentJoinAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    private final Weight inFilter;
    private final Weight outFilter;
    private final ValuesSource.Bytes.WithOrdinals valuesSource;
    private final CollectionStrategy collectionStrategy;

    public ParentJoinAggregator(String name, AggregatorFactories factories, AggregationContext context, Aggregator parent, Query inFilter, Query outFilter, ValuesSource.Bytes.WithOrdinals valuesSource, long maxOrd, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        if (maxOrd > Integer.MAX_VALUE) {
            throw new IllegalStateException("the number of parent [" + maxOrd + "] + is greater than the allowed limit for this aggregation: " + Integer.MAX_VALUE);
        }
        this.inFilter = context.searcher().createWeight(context.searcher().rewrite(inFilter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        this.outFilter = context.searcher().createWeight(context.searcher().rewrite(outFilter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        this.valuesSource = valuesSource;
        boolean singleAggregator = parent == null;
        this.collectionStrategy = singleAggregator && cardinality == CardinalityUpperBound.ONE ? new DenseCollectionStrategy(maxOrd, context.bigArrays()) : new SparseCollectionStrategy(context.bigArrays(), cardinality);
    }

    public final LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedSetDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(ctx);
        final Bits parentDocs = Lucene.asSequentialAccessBits((int)ctx.reader().maxDoc(), (ScorerSupplier)this.inFilter.scorerSupplier(ctx));
        return new LeafBucketCollector(){

            public void collect(int docId, long owningBucketOrd) throws IOException {
                if (parentDocs.get(docId) && globalOrdinals.advanceExact(docId)) {
                    int globalOrdinal = (int)globalOrdinals.nextOrd();
                    assert (globalOrdinal != -1 && globalOrdinals.nextOrd() == -1L);
                    ParentJoinAggregator.this.collectionStrategy.add(owningBucketOrd, globalOrdinal);
                }
            }
        };
    }

    public void postCollection() throws IOException {
    }

    protected void prepareSubAggs(long[] ordsToCollect) throws IOException {
        IndexReader indexReader = this.searcher().getIndexReader();
        for (LeafReaderContext ctx : indexReader.leaves()) {
            Scorer childDocsScorer = this.outFilter.scorer(ctx);
            if (childDocsScorer == null) continue;
            final DocIdSetIterator childDocsIter = childDocsScorer.iterator();
            LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(ctx);
            SortedSetDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(ctx);
            sub.setScorer(new Scorable(){

                public float score() {
                    return 1.0f;
                }

                public int docID() {
                    return childDocsIter.docID();
                }
            });
            Bits liveDocs = ctx.reader().getLiveDocs();
            int docId = childDocsIter.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                if ((liveDocs == null || liveDocs.get(docId)) && globalOrdinals.advanceExact(docId)) {
                    int globalOrdinal = (int)globalOrdinals.nextOrd();
                    assert (globalOrdinal != -1 && globalOrdinals.nextOrd() == -1L);
                    for (long owningBucketOrd : ordsToCollect) {
                        if (!this.collectionStrategy.exists(owningBucketOrd, globalOrdinal)) continue;
                        this.collectBucket(sub, docId, owningBucketOrd);
                    }
                }
                docId = childDocsIter.nextDoc();
            }
        }
        super.postCollection();
    }

    protected void doClose() {
        Releasables.close((Releasable)this.collectionStrategy);
    }

    protected static interface CollectionStrategy
    extends Releasable {
        public void add(long var1, int var3);

        public boolean exists(long var1, int var3);
    }

    protected class DenseCollectionStrategy
    implements CollectionStrategy {
        private final BitArray ordsBits;

        public DenseCollectionStrategy(long maxOrd, BigArrays bigArrays) {
            this.ordsBits = new BitArray(maxOrd, ParentJoinAggregator.this.bigArrays());
        }

        @Override
        public void add(long owningBucketOrd, int globalOrdinal) {
            assert (owningBucketOrd == 0L);
            this.ordsBits.set((long)globalOrdinal);
        }

        @Override
        public boolean exists(long owningBucketOrd, int globalOrdinal) {
            assert (owningBucketOrd == 0L);
            return this.ordsBits.get((long)globalOrdinal);
        }

        public void close() {
            this.ordsBits.close();
        }
    }

    protected class SparseCollectionStrategy
    implements CollectionStrategy {
        private final LongKeyedBucketOrds ordsHash;

        public SparseCollectionStrategy(BigArrays bigArrays, CardinalityUpperBound cardinality) {
            this.ordsHash = LongKeyedBucketOrds.build((BigArrays)bigArrays, (CardinalityUpperBound)cardinality);
        }

        @Override
        public void add(long owningBucketOrd, int globalOrdinal) {
            this.ordsHash.add(owningBucketOrd, (long)globalOrdinal);
        }

        @Override
        public boolean exists(long owningBucketOrd, int globalOrdinal) {
            return this.ordsHash.find(owningBucketOrd, (long)globalOrdinal) >= 0L;
        }

        public void close() {
            this.ordsHash.close();
        }
    }
}

