/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ServiceLoader;
import org.elasticsearch.xcontent.internal.EmbeddedImplClassLoader;
import org.elasticsearch.xcontent.spi.XContentProvider;

public final class ProviderLocator {
    public static final XContentProvider INSTANCE = ProviderLocator.provider();

    private static XContentProvider provider() {
        try {
            PrivilegedExceptionAction<XContentProvider> pa = ProviderLocator::loadAsNonModule;
            return AccessController.doPrivileged(pa);
        }
        catch (PrivilegedActionException e) {
            throw new UncheckedIOException((IOException)e.getCause());
        }
    }

    private static XContentProvider loadAsNonModule() {
        EmbeddedImplClassLoader loader = EmbeddedImplClassLoader.getInstance(ProviderLocator.class.getClassLoader(), "x-content");
        ServiceLoader<XContentProvider> sl = ServiceLoader.load(XContentProvider.class, loader);
        return sl.findFirst().orElseThrow(() -> new RuntimeException("cannot locate x-content provider"));
    }
}

