/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentLocation;

public class ParseField {
    private final String name;
    private final String[] deprecatedNames;
    private final Function<RestApiVersion, Boolean> forRestApiVersion;
    private final String allReplacedWith;
    private final boolean fullyDeprecated;
    private final String[] allNames;
    private static final String[] EMPTY = new String[0];

    private ParseField(String name, Function<RestApiVersion, Boolean> forRestApiVersion, String[] deprecatedNames, boolean fullyDeprecated, String allReplacedWith) {
        this.name = name;
        this.fullyDeprecated = fullyDeprecated;
        this.allReplacedWith = allReplacedWith;
        if (deprecatedNames == null || deprecatedNames.length == 0) {
            this.deprecatedNames = EMPTY;
        } else {
            HashSet set = new HashSet();
            Collections.addAll(set, deprecatedNames);
            this.deprecatedNames = set.toArray(new String[set.size()]);
        }
        this.forRestApiVersion = forRestApiVersion;
        HashSet<String> names = new HashSet<String>();
        names.add(name);
        Collections.addAll(names, this.deprecatedNames);
        this.allNames = names.toArray(new String[names.size()]);
    }

    public ParseField(String name, String ... deprecatedNames) {
        this(name, RestApiVersion.onOrAfter((RestApiVersion)RestApiVersion.minimumSupported()), deprecatedNames, false, null);
    }

    public String getPreferredName() {
        return this.name;
    }

    public String[] getAllNamesIncludedDeprecated() {
        return this.allNames;
    }

    public ParseField withDeprecation(String ... deprecatedNamesOverride) {
        return new ParseField(this.name, this.forRestApiVersion, deprecatedNamesOverride, this.fullyDeprecated, this.allReplacedWith);
    }

    public ParseField forRestApiVersion(Function<RestApiVersion, Boolean> forRestApiVersionOverride) {
        return new ParseField(this.name, forRestApiVersionOverride, this.deprecatedNames, this.fullyDeprecated, this.allReplacedWith);
    }

    public Function<RestApiVersion, Boolean> getForRestApiVersion() {
        return this.forRestApiVersion;
    }

    public ParseField withAllDeprecated(String allReplacedWithOverride) {
        return new ParseField(this.name, this.forRestApiVersion, this.getAllNamesIncludedDeprecated(), this.fullyDeprecated, allReplacedWithOverride);
    }

    public ParseField withAllDeprecated() {
        return new ParseField(this.name, this.forRestApiVersion, this.getAllNamesIncludedDeprecated(), true, this.allReplacedWith);
    }

    public boolean match(String fieldName, DeprecationHandler deprecationHandler) {
        return this.match(null, () -> XContentLocation.UNKNOWN, fieldName, deprecationHandler);
    }

    public boolean match(String parserName, Supplier<XContentLocation> location, String fieldName, DeprecationHandler deprecationHandler) {
        Objects.requireNonNull(fieldName, "fieldName cannot be null");
        if (!this.fullyDeprecated && this.allReplacedWith == null && fieldName.equals(this.name)) {
            return true;
        }
        boolean isCompatibleDeprecation = RestApiVersion.minimumSupported().matches(this.forRestApiVersion) && !RestApiVersion.current().matches(this.forRestApiVersion);
        for (String depName : this.deprecatedNames) {
            if (!fieldName.equals(depName)) continue;
            if (this.fullyDeprecated) {
                deprecationHandler.logRemovedField(parserName, location, fieldName, isCompatibleDeprecation);
            } else if (this.allReplacedWith == null) {
                deprecationHandler.logRenamedField(parserName, location, fieldName, this.name, isCompatibleDeprecation);
            } else {
                deprecationHandler.logReplacedField(parserName, location, fieldName, this.allReplacedWith, isCompatibleDeprecation);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getPreferredName();
    }

    public String getAllReplacedWith() {
        return this.allReplacedWith;
    }

    public String[] getDeprecatedNames() {
        return this.deprecatedNames;
    }

    public static class CommonFields {
        public static final ParseField FIELD = new ParseField("field", new String[0]);
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
        public static final ParseField MISSING = new ParseField("missing", new String[0]);
        public static final ParseField TIME_ZONE = new ParseField("time_zone", new String[0]);

        protected CommonFields() {
        }
    }
}

