/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class MemorySegmentUtil {
    static String getString(MemorySegment segment, long offset) {
        return segment.getString(offset);
    }

    static void setString(MemorySegment segment, long offset, String value) {
        segment.setString(offset, value);
    }

    static MemorySegment allocateString(Arena arena, String s) {
        return arena.allocateFrom(s);
    }

    static VarHandle varHandleWithoutOffset(MemoryLayout layout, MemoryLayout.PathElement element) {
        return MethodHandles.insertCoordinates(layout.varHandle(element), 1, 0L);
    }

    private MemorySegmentUtil() {
    }
}

