/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import org.elasticsearch.nativeaccess.jdk.JdkPosixCLibrary;
import org.elasticsearch.nativeaccess.jdk.LinkerHelper;
import org.elasticsearch.nativeaccess.lib.LinuxCLibrary;

class JdkLinuxCLibrary
implements LinuxCLibrary {
    private static final MethodHandle prctl$mh;
    private static final MethodHandle syscall$mh;
    private static final MethodHandle fallocate$mh;

    JdkLinuxCLibrary() {
    }

    @Override
    public LinuxCLibrary.SockFProg newSockFProg(LinuxCLibrary.SockFilter[] filters) {
        return new JdkSockFProg(filters);
    }

    @Override
    public int prctl(int option, long arg2, long arg3, long arg4, long arg5) {
        try {
            return prctl$mh.invokeExact(JdkPosixCLibrary.errnoState, option, arg2, arg3, arg4, arg5);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public long syscall(long number, int operation, int flags, long address) {
        try {
            return syscall$mh.invokeExact(JdkPosixCLibrary.errnoState, number, operation, flags, address);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int fallocate(int fd, int mode, long offset, long length) {
        try {
            return fallocate$mh.invokeExact(JdkPosixCLibrary.errnoState, fd, mode, offset, length);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    static {
        try {
            prctl$mh = JdkPosixCLibrary.downcallHandleWithErrno("prctl", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG));
        }
        catch (UnsatisfiedLinkError e) {
            throw new UnsupportedOperationException("seccomp unavailable: could not link methods. requires kernel 3.5+ with CONFIG_SECCOMP and CONFIG_SECCOMP_FILTER compiled in");
        }
        syscall$mh = LinkerHelper.downcallHandle("syscall", FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG), JdkPosixCLibrary.CAPTURE_ERRNO_OPTION, Linker.Option.firstVariadicArg(1));
        fallocate$mh = JdkPosixCLibrary.downcallHandleWithErrno("fallocate", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG));
    }

    private static class JdkSockFProg
    implements LinuxCLibrary.SockFProg {
        private static final MemoryLayout layout = MemoryLayout.structLayout(ValueLayout.JAVA_SHORT, MemoryLayout.paddingLayout(6L), ValueLayout.ADDRESS);
        private final MemorySegment segment;

        JdkSockFProg(LinuxCLibrary.SockFilter[] filters) {
            Arena arena = Arena.ofAuto();
            this.segment = arena.allocate(layout);
            MemorySegment instSegment = arena.allocate((long)filters.length * 8L);
            this.segment.set(ValueLayout.JAVA_SHORT, 0L, (short)filters.length);
            this.segment.set(ValueLayout.ADDRESS, 8L, instSegment);
            int offset = 0;
            for (LinuxCLibrary.SockFilter f : filters) {
                instSegment.set(ValueLayout.JAVA_SHORT, (long)offset, f.code());
                instSegment.set(ValueLayout.JAVA_BYTE, (long)(offset + 2), f.jt());
                instSegment.set(ValueLayout.JAVA_BYTE, (long)(offset + 3), f.jf());
                instSegment.set(ValueLayout.JAVA_INT, (long)(offset + 4), f.k());
                offset += 8;
            }
        }

        @Override
        public long address() {
            return this.segment.address();
        }
    }
}

