/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.core.IndexerJobStats;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameIndexerTransformStats
extends IndexerJobStats {
    static ParseField EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS = new ParseField("exponential_avg_checkpoint_duration_ms", new String[0]);
    static ParseField EXPONENTIAL_AVG_DOCUMENTS_INDEXED = new ParseField("exponential_avg_documents_indexed", new String[0]);
    static ParseField EXPONENTIAL_AVG_DOCUMENTS_PROCESSED = new ParseField("exponential_avg_documents_processed", new String[0]);
    public static final ConstructingObjectParser<DataFrameIndexerTransformStats, Void> LENIENT_PARSER = new ConstructingObjectParser("data_frame_indexer_transform_stats", true, args -> new DataFrameIndexerTransformStats((Long)args[0], (Long)args[1], (Long)args[2], (Long)args[3], (Long)args[4], (Long)args[5], (Long)args[6], (Long)args[7], (Long)args[8], (Long)args[9], (Double)args[10], (Double)args[11], (Double)args[12]));
    private final double expAvgCheckpointDurationMs;
    private final double expAvgDocumentsIndexed;
    private final double expAvgDocumentsProcessed;

    public static DataFrameIndexerTransformStats fromXContent(XContentParser parser) throws IOException {
        return (DataFrameIndexerTransformStats)LENIENT_PARSER.parse(parser, null);
    }

    public DataFrameIndexerTransformStats(long numPages, long numInputDocuments, long numOuputDocuments, long numInvocations, long indexTime, long searchTime, long indexTotal, long searchTotal, long indexFailures, long searchFailures, Double expAvgCheckpointDurationMs, Double expAvgDocumentsIndexed, Double expAvgDocumentsProcessed) {
        super(numPages, numInputDocuments, numOuputDocuments, numInvocations, indexTime, searchTime, indexTotal, searchTotal, indexFailures, searchFailures);
        this.expAvgCheckpointDurationMs = expAvgCheckpointDurationMs == null ? 0.0 : expAvgCheckpointDurationMs;
        this.expAvgDocumentsIndexed = expAvgDocumentsIndexed == null ? 0.0 : expAvgDocumentsIndexed;
        this.expAvgDocumentsProcessed = expAvgDocumentsProcessed == null ? 0.0 : expAvgDocumentsProcessed;
    }

    public double getExpAvgCheckpointDurationMs() {
        return this.expAvgCheckpointDurationMs;
    }

    public double getExpAvgDocumentsIndexed() {
        return this.expAvgDocumentsIndexed;
    }

    public double getExpAvgDocumentsProcessed() {
        return this.expAvgDocumentsProcessed;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameIndexerTransformStats that = (DataFrameIndexerTransformStats)other;
        return Objects.equals(this.numPages, that.numPages) && Objects.equals(this.numInputDocuments, that.numInputDocuments) && Objects.equals(this.numOuputDocuments, that.numOuputDocuments) && Objects.equals(this.numInvocations, that.numInvocations) && Objects.equals(this.indexTime, that.indexTime) && Objects.equals(this.searchTime, that.searchTime) && Objects.equals(this.indexFailures, that.indexFailures) && Objects.equals(this.searchFailures, that.searchFailures) && Objects.equals(this.indexTotal, that.indexTotal) && Objects.equals(this.searchTotal, that.searchTotal) && Objects.equals(this.expAvgCheckpointDurationMs, that.expAvgCheckpointDurationMs) && Objects.equals(this.expAvgDocumentsIndexed, that.expAvgDocumentsIndexed) && Objects.equals(this.expAvgDocumentsProcessed, that.expAvgDocumentsProcessed);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.numPages, this.numInputDocuments, this.numOuputDocuments, this.numInvocations, this.indexTime, this.searchTime, this.indexFailures, this.searchFailures, this.indexTotal, this.searchTotal, this.expAvgCheckpointDurationMs, this.expAvgDocumentsIndexed, this.expAvgDocumentsProcessed);
    }

    static {
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_PAGES);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INPUT_DOCUMENTS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_OUTPUT_DOCUMENTS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INVOCATIONS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_TIME_IN_MS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_TIME_IN_MS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_TOTAL);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_TOTAL);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_FAILURES);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_FAILURES);
        LENIENT_PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS);
        LENIENT_PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_DOCUMENTS_INDEXED);
        LENIENT_PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_DOCUMENTS_PROCESSED);
    }
}

