/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractSourceJarMojo
extends AbstractMojo {
    private static final Object LOCK = new Object();
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*"};
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="true")
    private boolean useDefaultExcludes;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="session", readonly=true)
    protected MavenSession session;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", required=true, readonly=true)
    private File defaultManifestFile;
    @Parameter(defaultValue="false")
    private boolean useDefaultManifestFile;
    @Parameter(property="attach", defaultValue="true")
    private boolean attach;
    @Parameter(property="source.excludeResources", defaultValue="false")
    protected boolean excludeResources;
    @Parameter(property="source.includePom", defaultValue="false")
    protected boolean includePom;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="project.build.directory")
    protected File outputDirectory;
    @Parameter(property="project.build.finalName")
    protected String finalName;
    @Parameter(property="reactorProjects", readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(property="source.forceCreation", defaultValue="false")
    private boolean forceCreation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Object object = LOCK;
        synchronized (object) {
            this.packageSources(this.project);
        }
    }

    protected abstract String getClassifier();

    protected abstract List<Resource> getSources(MavenProject var1) throws MojoExecutionException;

    protected abstract List<Resource> getResources(MavenProject var1) throws MojoExecutionException;

    protected void packageSources(MavenProject p) throws MojoExecutionException {
        if (this.isRelevantProject(p)) {
            this.packageSources(Collections.singletonList(p));
        }
    }

    protected abstract boolean isRelevantProject(MavenProject var1);

    protected void packageSources(List<MavenProject> projects) throws MojoExecutionException {
        if (this.project.getArtifact().hasClassifier()) {
            this.getLog().warn((CharSequence)("NOT adding sources to artifacts with classifier as Maven only supports one classifier per artifact. Current artifact [" + this.project.getArtifact().getId() + "] has a [" + this.project.getArtifact().getClassifier() + "] classifier"));
            return;
        }
        MavenArchiver archiver = this.createArchiver();
        Iterator<MavenProject> i = projects.iterator();
        while (i.hasNext()) {
            MavenProject subProject = this.getProject(i.next());
            if ("pom".equals(subProject.getPackaging())) continue;
            this.archiveProjectContent(subProject, (Archiver)archiver.getArchiver());
        }
        if (this.useDefaultManifestFile && this.defaultManifestFile.exists() && this.archive.getManifestFile() == null) {
            this.getLog().info((CharSequence)("Adding existing MANIFEST.MF to archive. Found under: " + this.defaultManifestFile.getPath()));
            this.archive.setManifestFile(this.defaultManifestFile);
        }
        this.updateSourceManifest(this.archive);
        File outputFile = new File(this.outputDirectory, this.finalName + "-" + this.getClassifier() + this.getExtension());
        try {
            archiver.setOutputFile(outputFile);
            this.archive.setAddMavenDescriptor(false);
            if (!this.archive.isForced()) {
                this.getLog().warn((CharSequence)"Ignoring unsupported archive 'forced = false' parameter");
                this.archive.setForced(true);
            }
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (IOException | DependencyResolutionRequiredException | ArchiverException | ManifestException e) {
            throw new MojoExecutionException("Error creating source archive: " + e.getMessage(), (Exception)e);
        }
        if (this.attach) {
            this.projectHelper.attachArtifact(this.project, this.getType(), this.getClassifier(), outputFile);
        } else {
            this.getLog().info((CharSequence)"NOT adding java-sources to attached artifacts list");
        }
    }

    protected void updateSourceManifest(MavenArchiveConfiguration mavenArchiveConfiguration) {
    }

    protected void archiveProjectContent(MavenProject p, Archiver archiver) throws MojoExecutionException {
        File sourceDirectory;
        if (this.includePom) {
            try {
                archiver.addFile(p.getFile(), p.getFile().getName());
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error adding POM file to target jar file.", (Exception)((Object)e));
            }
        }
        for (Resource resource : this.getSources(p)) {
            sourceDirectory = new File(resource.getDirectory());
            if (!sourceDirectory.exists()) continue;
            Object path = resource.getTargetPath();
            if (path == null) {
                this.addDirectory(archiver, sourceDirectory, this.getCombinedIncludes(null), this.getCombinedExcludes(null));
                continue;
            }
            if (!((String)path).trim().endsWith("/")) {
                path = (String)path + "/";
            }
            this.addDirectory(archiver, sourceDirectory, (String)path, this.getCombinedIncludes(null), this.getCombinedExcludes(null));
        }
        for (Resource resource : this.getResources(p)) {
            sourceDirectory = new File(resource.getDirectory());
            if (!sourceDirectory.exists()) continue;
            List resourceIncludes = resource.getIncludes();
            String[] combinedIncludes = this.getCombinedIncludes(resourceIncludes);
            List resourceExcludes = resource.getExcludes();
            String[] combinedExcludes = this.getCombinedExcludes(resourceExcludes);
            Object targetPath = resource.getTargetPath();
            if (targetPath != null) {
                if (!((String)targetPath).trim().endsWith("/")) {
                    targetPath = (String)targetPath + "/";
                }
                this.addDirectory(archiver, sourceDirectory, (String)targetPath, combinedIncludes, combinedExcludes);
                continue;
            }
            this.addDirectory(archiver, sourceDirectory, combinedIncludes, combinedExcludes);
        }
    }

    protected MavenArchiver createArchiver() throws MojoExecutionException {
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        if (this.project.getBuild() != null) {
            List resources = this.project.getBuild().getResources();
            for (Resource r : resources) {
                if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
                this.addDirectory((Archiver)archiver.getArchiver(), new File(r.getDirectory()), this.getCombinedIncludes(null), this.getCombinedExcludes(null));
            }
        }
        return archiver;
    }

    protected void addDirectory(Archiver archiver, File sourceDirectory, String[] includes, String[] excludes) throws MojoExecutionException {
        try {
            archiver.addFileSet((FileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)sourceDirectory).prefixed("")).includeExclude(includes, excludes));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error adding directory to source archive.", (Exception)((Object)e));
        }
    }

    protected void addDirectory(Archiver archiver, File sourceDirectory, String prefix, String[] includes, String[] excludes) throws MojoExecutionException {
        try {
            archiver.addFileSet((FileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)sourceDirectory).prefixed(prefix)).includeExclude(includes, excludes));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error adding directory to source archive.", (Exception)((Object)e));
        }
    }

    protected String getExtension() {
        return ".jar";
    }

    protected MavenProject getProject(MavenProject p) {
        if (p.getExecutionProject() != null) {
            return p.getExecutionProject();
        }
        return p;
    }

    protected String getType() {
        return "java-source";
    }

    private String[] getCombinedIncludes(List<String> additionalIncludes) {
        ArrayList<String> combinedIncludes = new ArrayList<String>();
        if (this.includes != null && this.includes.length > 0) {
            combinedIncludes.addAll(Arrays.asList(this.includes));
        }
        if (additionalIncludes != null && additionalIncludes.size() > 0) {
            combinedIncludes.addAll(additionalIncludes);
        }
        if (combinedIncludes.isEmpty()) {
            combinedIncludes.addAll(Arrays.asList(DEFAULT_INCLUDES));
        }
        return combinedIncludes.toArray(new String[combinedIncludes.size()]);
    }

    private String[] getCombinedExcludes(List<String> additionalExcludes) {
        ArrayList<String> combinedExcludes = new ArrayList<String>();
        if (this.useDefaultExcludes) {
            combinedExcludes.addAll(FileUtils.getDefaultExcludesAsList());
        }
        if (this.excludes != null && this.excludes.length > 0) {
            combinedExcludes.addAll(Arrays.asList(this.excludes));
        }
        if (additionalExcludes != null && additionalExcludes.size() > 0) {
            combinedExcludes.addAll(additionalExcludes);
        }
        if (combinedExcludes.isEmpty()) {
            combinedExcludes.addAll(Arrays.asList(DEFAULT_EXCLUDES));
        }
        return combinedExcludes.toArray(new String[combinedExcludes.size()]);
    }
}

