/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.maven;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.execution.ProjectExecutionEvent;
import org.apache.maven.execution.ProjectExecutionListener;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.bnd.maven.BndMavenLifecycleParticipant;

@Component(role=ProjectExecutionListener.class)
public class BndProjectExecutionListener
implements ProjectExecutionListener {
    public void beforeProjectExecution(ProjectExecutionEvent event) throws LifecycleExecutionException {
    }

    public void beforeProjectLifecycleExecution(ProjectExecutionEvent event) throws LifecycleExecutionException {
        if (BndMavenLifecycleParticipant.isBNDProject(event.getProject())) {
            List executionPlan = event.getExecutionPlan();
            Iterator iterator = executionPlan.iterator();
            while (iterator.hasNext()) {
                MojoExecution mojoExecution = (MojoExecution)iterator.next();
                if (!this.isUnwantedExecution(mojoExecution)) continue;
                iterator.remove();
            }
        }
    }

    private boolean isUnwantedExecution(MojoExecution mojoExecution) {
        if (this.matches(mojoExecution, "org.apache.maven.plugins", "maven-compiler-plugin", "default-compile")) {
            return true;
        }
        if (this.matches(mojoExecution, "org.apache.maven.plugins", "maven-compiler-plugin", "default-testCompile")) {
            return true;
        }
        if (this.matches(mojoExecution, "org.apache.maven.plugins", "maven-surefire-plugin", "default-test")) {
            return true;
        }
        if (this.matches(mojoExecution, "org.apache.maven.plugins", "maven-jar-plugin", "default-jar")) {
            return true;
        }
        if (this.matches(mojoExecution, "org.apache.maven.plugins", "maven-clean-plugin", "default-clean")) {
            return true;
        }
        if (this.matches(mojoExecution, "org.apache.maven.plugins", "maven-resources-plugin", "default-resources")) {
            return true;
        }
        return this.matches(mojoExecution, "org.apache.maven.plugins", "maven-resources-plugin", "default-testResources");
    }

    private boolean matches(MojoExecution mojoExecution, String groupId, String artifactId, String id) {
        return id.equals(mojoExecution.getExecutionId()) && groupId.equals(mojoExecution.getGroupId()) && artifactId.equals(mojoExecution.getArtifactId());
    }

    public void afterProjectExecutionSuccess(ProjectExecutionEvent event) throws LifecycleExecutionException {
    }

    public void afterProjectExecutionFailure(ProjectExecutionEvent event) {
    }
}

