/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine;

import java.util.List;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.NestedClassTestDescriptor;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.PackageNameFilter;

class DiscoveryFilterApplier {
    DiscoveryFilterApplier() {
    }

    void applyAllFilters(EngineDiscoveryRequest discoveryRequest, TestDescriptor engineDescriptor) {
        this.applyClassNameFilters(discoveryRequest.getFiltersByType(ClassNameFilter.class), engineDescriptor);
        this.applyPackageNameFilters(discoveryRequest.getFiltersByType(PackageNameFilter.class), engineDescriptor);
    }

    private void applyPackageNameFilters(List<PackageNameFilter> packageNameFilters, TestDescriptor engineDescriptor) {
        if (packageNameFilters.isEmpty()) {
            return;
        }
        TestDescriptor.Visitor filteringVisitor = descriptor -> {
            if (descriptor instanceof ClassTestDescriptor && !this.includePackage((ClassTestDescriptor)descriptor, packageNameFilters)) {
                descriptor.removeFromHierarchy();
            }
        };
        engineDescriptor.accept(filteringVisitor);
    }

    private boolean includePackage(ClassTestDescriptor classTestDescriptor, List<PackageNameFilter> packageNameFilters) {
        if (classTestDescriptor instanceof NestedClassTestDescriptor) {
            return true;
        }
        Class<?> testClass = classTestDescriptor.getTestClass();
        return packageNameFilters.stream().map(filter -> filter.apply(testClass.getPackage().getName())).noneMatch(FilterResult::excluded);
    }

    private void applyClassNameFilters(List<ClassNameFilter> classNameFilters, TestDescriptor engineDescriptor) {
        if (classNameFilters.isEmpty()) {
            return;
        }
        TestDescriptor.Visitor filteringVisitor = descriptor -> {
            if (descriptor instanceof ClassTestDescriptor && !this.includeClass((ClassTestDescriptor)descriptor, classNameFilters)) {
                descriptor.removeFromHierarchy();
            }
        };
        engineDescriptor.accept(filteringVisitor);
    }

    private boolean includeClass(ClassTestDescriptor classTestDescriptor, List<ClassNameFilter> classNameFilters) {
        if (classTestDescriptor instanceof NestedClassTestDescriptor) {
            return true;
        }
        Class<?> testClass = classTestDescriptor.getTestClass();
        return classNameFilters.stream().map(filter -> filter.apply(testClass.getName())).noneMatch(FilterResult::excluded);
    }
}

