/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.model.Property;
import org.eclipse.milo.opcua.sdk.core.model.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.sdk.server.nodes.ServerNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaPropertyNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.AttributeDelegate;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaNode
implements ServerNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(UaNode.class);
    private static final AttributeDelegate DEFAULT_ATTRIBUTE_DELEGATE = AttributeDelegate.DEFAULT;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final List<Reference> references = new CopyOnWriteArrayList<Reference>();
    private final AtomicReference<AttributeDelegate> attributeDelegate = new AtomicReference<AttributeDelegate>(DEFAULT_ATTRIBUTE_DELEGATE);
    private List<WeakReference<AttributeObserver>> observers;
    private final ServerNodeMap nodeMap;
    private volatile NodeId nodeId;
    private volatile NodeClass nodeClass;
    private volatile QualifiedName browseName;
    private volatile LocalizedText displayName;
    private volatile LocalizedText description;
    private volatile UInteger writeMask;
    private volatile UInteger userWriteMask;

    protected UaNode(ServerNodeMap nodeMap, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName) {
        this(nodeMap, nodeId, nodeClass, browseName, displayName, LocalizedText.NULL_VALUE, UInteger.MIN, UInteger.MIN);
    }

    protected UaNode(ServerNodeMap nodeMap, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        this.nodeMap = nodeMap;
        this.nodeId = nodeId;
        this.nodeClass = nodeClass;
        this.browseName = browseName;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public NodeClass getNodeClass() {
        return this.nodeClass;
    }

    @Override
    public QualifiedName getBrowseName() {
        return this.browseName;
    }

    @Override
    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    @Override
    public LocalizedText getDescription() {
        return this.description;
    }

    @Override
    public UInteger getWriteMask() {
        return this.writeMask;
    }

    @Override
    public UInteger getUserWriteMask() {
        return this.userWriteMask;
    }

    @Override
    public synchronized void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
        this.fireAttributeChanged(AttributeId.NodeId, nodeId);
    }

    @Override
    public synchronized void setNodeClass(NodeClass nodeClass) {
        this.nodeClass = nodeClass;
        this.fireAttributeChanged(AttributeId.NodeClass, nodeClass);
    }

    @Override
    public synchronized void setBrowseName(QualifiedName browseName) {
        this.browseName = browseName;
        this.fireAttributeChanged(AttributeId.BrowseName, browseName);
    }

    @Override
    public synchronized void setDisplayName(LocalizedText displayName) {
        this.displayName = displayName;
        this.fireAttributeChanged(AttributeId.DisplayName, displayName);
    }

    @Override
    public synchronized void setDescription(LocalizedText description) {
        this.description = description;
        this.fireAttributeChanged(AttributeId.Description, description);
    }

    @Override
    public synchronized void setWriteMask(UInteger writeMask) {
        this.writeMask = writeMask;
        this.fireAttributeChanged(AttributeId.WriteMask, writeMask);
    }

    @Override
    public synchronized void setUserWriteMask(UInteger userWriteMask) {
        this.userWriteMask = userWriteMask;
        this.fireAttributeChanged(AttributeId.UserWriteMask, userWriteMask);
    }

    public ServerNodeMap getNodeMap() {
        return this.nodeMap;
    }

    protected Optional<ServerNode> getNode(NodeId nodeId) {
        return this.nodeMap.getNode(nodeId);
    }

    protected Optional<ServerNode> getNode(ExpandedNodeId nodeId) {
        return this.nodeMap.getNode(nodeId);
    }

    @Override
    public ImmutableList<Reference> getReferences() {
        return ImmutableList.copyOf(this.references);
    }

    @Override
    public synchronized void addReference(Reference reference) {
        this.references.add(reference);
        if (reference.isInverse()) {
            int count = this.refCount.incrementAndGet();
            LOGGER.trace("{} refCount={}", (Object)this.getNodeId(), (Object)count);
            if (count == 1) {
                this.nodeMap.addNode(this);
            }
        }
    }

    @Override
    public synchronized void addReferences(Collection<Reference> c) {
        c.forEach(this::addReference);
    }

    @Override
    public synchronized void removeReference(Reference reference) {
        this.references.remove(reference);
        if (reference.isInverse()) {
            int count = this.refCount.decrementAndGet();
            LOGGER.trace("{} refCount={}", (Object)this.getNodeId(), (Object)count);
            if (count == 0) {
                this.deallocate();
            }
        }
    }

    @Override
    public synchronized void removeReferences(Collection<Reference> c) {
        c.forEach(this::removeReference);
    }

    protected synchronized void deallocate() {
        LOGGER.trace("{} deallocate()", (Object)this.getNodeId());
        ExpandedNodeId expanded = this.getNodeId().expanded();
        List referencedNodes = this.getReferences().stream().filter(Reference::isForward).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).collect(Collectors.toList());
        for (ServerNode node : referencedNodes) {
            List<Reference> inverseReferences = node.getReferences().stream().filter(Reference::isInverse).filter(r -> r.getTargetNodeId().equals((Object)expanded)).collect(Collectors.toList());
            node.removeReferences(inverseReferences);
        }
        this.nodeMap.removeNode(this.getNodeId());
    }

    public <T> Optional<T> getProperty(Property<T> property) {
        return this.getProperty(property.getBrowseName());
    }

    public <T> Optional<T> getProperty(QualifiedProperty<T> property) {
        return this.getProperty(property.getBrowseName());
    }

    public <T> Optional<T> getProperty(String browseName) {
        return this.getProperty(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    public <T> Optional<T> getProperty(QualifiedName browseName) {
        Node node = this.getPropertyNode(browseName).orElse(null);
        try {
            return Optional.ofNullable(((VariableNode)node).getValue().getValue().getValue());
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public <T> void setProperty(Property<T> property, T value) {
        VariableNode node = this.getPropertyNode(property.getBrowseName()).orElseGet(() -> {
            QualifiedName browseName = property.getBrowseName();
            NodeId propertyNodeId = new NodeId(this.getNodeId().getNamespaceIndex(), String.format("%s.%s", this.getNodeId().getIdentifier().toString(), browseName.getName()));
            UaPropertyNode propertyNode = new UaPropertyNode(this.getNodeMap(), propertyNodeId, browseName, LocalizedText.english((String)browseName.getName()));
            propertyNode.setDataType(property.getDataType());
            propertyNode.setValueRank(property.getValueRank());
            this.addProperty(propertyNode);
            return propertyNode;
        });
        node.setValue(new DataValue(new Variant(value)));
    }

    public <T> void setProperty(QualifiedProperty<T> property, T value) {
        VariableNode node = this.getPropertyNode(property.getBrowseName()).orElseGet(() -> {
            String browseName = property.getBrowseName();
            NodeId propertyNodeId = new NodeId(this.getNodeId().getNamespaceIndex(), String.format("%s.%s", this.getNodeId().getIdentifier().toString(), browseName));
            UaPropertyNode propertyNode = new UaPropertyNode(this.getNodeMap(), propertyNodeId, new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName), LocalizedText.english((String)browseName));
            propertyNode.setDataType(property.getDataType());
            propertyNode.setValueRank(property.getValueRank());
            this.addProperty(propertyNode);
            return propertyNode;
        });
        node.setValue(new DataValue(new Variant(value)));
    }

    public Optional<VariableNode> getPropertyNode(Property<?> property) {
        return this.getPropertyNode(property.getBrowseName());
    }

    public Optional<VariableNode> getPropertyNode(QualifiedProperty<?> property) {
        return this.getPropertyNode(property.getBrowseName());
    }

    public Optional<VariableNode> getPropertyNode(String browseName) {
        return this.getPropertyNode(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    public Optional<VariableNode> getPropertyNode(QualifiedName browseName) {
        Node node = this.references.stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).filter(n -> n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        try {
            return Optional.ofNullable((VariableNode)node);
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public void addProperty(UaVariableNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasProperty, node.getNodeId().expanded(), NodeClass.Variable, true));
        node.addReference(new Reference(node.getNodeId(), Identifiers.HasProperty, this.getNodeId().expanded(), this.getNodeClass(), false));
    }

    public void removeProperty(UaVariableNode node) {
        this.removeReference(new Reference(this.getNodeId(), Identifiers.HasProperty, node.getNodeId().expanded(), NodeClass.Variable, true));
        node.removeReference(new Reference(node.getNodeId(), Identifiers.HasProperty, this.getNodeId().expanded(), this.getNodeClass(), false));
    }

    protected Optional<ObjectNode> getObjectComponent(String namespaceUri, String name) {
        UShort namespaceIndex = this.nodeMap.getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getObjectComponent(new QualifiedName(namespaceIndex, name));
        }
        return Optional.empty();
    }

    protected Optional<ObjectNode> getObjectComponent(String browseName) {
        return this.getObjectComponent(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    protected Optional<ObjectNode> getObjectComponent(QualifiedName browseName) {
        ObjectNode node = this.references.stream().filter(Reference.HAS_COMPONENT_PREDICATE.and(r -> r.getTargetNodeClass() == NodeClass.Object)).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).filter(n -> n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        return Optional.ofNullable(node);
    }

    protected Optional<VariableNode> getVariableComponent(String namespaceUri, String name) {
        UShort namespaceIndex = this.nodeMap.getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getVariableComponent(new QualifiedName(namespaceIndex, name));
        }
        return Optional.empty();
    }

    protected Optional<VariableNode> getVariableComponent(String browseName) {
        return this.getVariableComponent(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    protected Optional<VariableNode> getVariableComponent(QualifiedName browseName) {
        VariableNode node = this.references.stream().filter(Reference.HAS_COMPONENT_PREDICATE.and(r -> r.getTargetNodeClass() == NodeClass.Variable)).flatMap(r -> StreamUtil.opt2stream(this.getNode(r.getTargetNodeId()))).filter(n -> n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        return Optional.ofNullable(node);
    }

    public synchronized void addAttributeObserver(AttributeObserver observer) {
        if (this.observers == null) {
            this.observers = new LinkedList<WeakReference<AttributeObserver>>();
        }
        this.observers.add(new WeakReference<AttributeObserver>(observer));
    }

    public synchronized void removeAttributeObserver(AttributeObserver observer) {
        if (this.observers == null) {
            return;
        }
        Iterator<WeakReference<AttributeObserver>> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            WeakReference<AttributeObserver> ref = iterator.next();
            if (ref.get() != null && ref.get() != observer) continue;
            iterator.remove();
        }
        if (this.observers.isEmpty()) {
            this.observers = null;
        }
    }

    protected synchronized void fireAttributeChanged(AttributeId attributeId, Object attributeValue) {
        if (this.observers == null) {
            return;
        }
        Iterator<WeakReference<AttributeObserver>> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            WeakReference<AttributeObserver> ref = iterator.next();
            AttributeObserver observer = (AttributeObserver)ref.get();
            if (observer != null) {
                observer.attributeChanged(this, attributeId, attributeValue);
                continue;
            }
            iterator.remove();
        }
    }

    public void setAttributeDelegate(@Nonnull AttributeDelegate attributeDelegate) {
        Preconditions.checkNotNull((Object)attributeDelegate);
        this.attributeDelegate.set(attributeDelegate);
    }

    @Override
    public DataValue getAttribute(AttributeContext context, AttributeId attributeId) {
        return this.attributeDelegate.get().getAttribute(context, this, attributeId);
    }

    @Override
    public void setAttribute(AttributeContext context, AttributeId attributeId, DataValue value) throws UaException {
        this.attributeDelegate.get().setAttribute(context, this, attributeId, value);
    }
}

