/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.server.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class NodeFactory {
    private final ServerNodeMap nodeMap;
    private final ObjectTypeManager objectTypeManager;
    private final VariableTypeManager variableTypeManager;

    public NodeFactory(ServerNodeMap nodeMap, ObjectTypeManager objectTypeManager, VariableTypeManager variableTypeManager) {
        this.nodeMap = nodeMap;
        this.objectTypeManager = objectTypeManager;
        this.variableTypeManager = variableTypeManager;
    }

    public UaObjectNode createObject(NodeId nodeId, QualifiedName browseName, LocalizedText displayName, NodeId typeDefinitionId) {
        UaObjectNode objectNode = this.createObject(nodeId, typeDefinitionId);
        objectNode.setBrowseName(browseName);
        objectNode.setDisplayName(displayName);
        return objectNode;
    }

    public <T extends ObjectNode> T createObject(NodeId nodeId, QualifiedName browseName, LocalizedText displayName, NodeId typeDefinitionId, Class<T> clazz) {
        ObjectNode objectNode = (ObjectNode)this.createNode(nodeId, typeDefinitionId, clazz);
        objectNode.setBrowseName(browseName);
        objectNode.setDisplayName(displayName);
        return (T)objectNode;
    }

    public UaVariableNode createVariable(NodeId nodeId, QualifiedName browseName, LocalizedText displayName, NodeId typeDefinitionId) {
        UaVariableNode variableNode = this.createVariable(nodeId, typeDefinitionId);
        variableNode.setBrowseName(browseName);
        variableNode.setDisplayName(displayName);
        return variableNode;
    }

    public <T extends VariableNode> T createVariable(NodeId nodeId, QualifiedName browseName, LocalizedText displayName, NodeId typeDefinitionId, Class<T> clazz) {
        VariableNode variableNode = (VariableNode)this.createNode(nodeId, typeDefinitionId, clazz);
        variableNode.setBrowseName(browseName);
        variableNode.setDisplayName(displayName);
        return (T)variableNode;
    }

    private UaObjectNode createObject(NodeId nodeId, NodeId typeDefinitionId) throws UaRuntimeException {
        return this.createNode(nodeId, typeDefinitionId, UaObjectNode.class);
    }

    private UaVariableNode createVariable(NodeId nodeId, NodeId typeDefinitionId) throws UaRuntimeException {
        return this.createNode(nodeId, typeDefinitionId, UaVariableNode.class);
    }

    private <T extends Node> T createNode(NodeId nodeId, NodeId typeDefinitionId, Class<T> clazz) throws UaRuntimeException {
        UaNode node;
        UaNode typeDefinitionNode = (UaNode)this.nodeMap.getNode(typeDefinitionId).orElseThrow(() -> new UaRuntimeException(2150891520L, "unknown type definition: " + typeDefinitionId));
        if (typeDefinitionNode instanceof VariableTypeNode) {
            node = this.instanceFromTypeDefinition(nodeId, (UaVariableTypeNode)typeDefinitionNode);
            this.nodeMap.addNode(node);
        } else if (typeDefinitionNode instanceof ObjectTypeNode) {
            node = this.instanceFromTypeDefinition(nodeId, (UaObjectTypeNode)typeDefinitionNode);
            this.nodeMap.addNode(node);
        } else {
            throw new UaRuntimeException(0x80010000L, "typeDefinitionNode: " + typeDefinitionNode);
        }
        List propertyDeclarations = typeDefinitionNode.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).distinct().map(r -> this.nodeMap.getNode(r.getTargetNodeId())).flatMap(StreamUtil::opt2stream).map(UaVariableNode.class::cast).filter(vn -> vn.getReferences().stream().anyMatch(r -> Identifiers.HasModellingRule.equals((Object)r.getReferenceTypeId()) && Identifiers.ModellingRule_Mandatory.expanded().equals((Object)r.getTargetNodeId()))).collect(Collectors.toList());
        for (Object declaration : propertyDeclarations) {
            UaVariableTypeNode typeDefinition = (UaVariableTypeNode)((UaVariableNode)declaration).getTypeDefinitionNode();
            NodeId instanceId = this.createNodeId(nodeId, ((UaNode)declaration).getBrowseName().getName());
            UaVariableNode instance = this.createVariable(instanceId, typeDefinition.getNodeId());
            instance.setBrowseName(((UaNode)declaration).getBrowseName());
            instance.setDisplayName(((UaNode)declaration).getDisplayName());
            instance.setDescription(((UaNode)declaration).getDescription());
            instance.setWriteMask(((UaNode)declaration).getWriteMask());
            instance.setUserWriteMask(((UaNode)declaration).getUserWriteMask());
            instance.setValue(((UaVariableNode)declaration).getValue());
            instance.setDataType(((UaVariableNode)declaration).getDataType());
            instance.setValueRank(((UaVariableNode)declaration).getValueRank());
            instance.setArrayDimensions(((UaVariableNode)declaration).getArrayDimensions());
            node.addProperty(instance);
            this.nodeMap.addNode(instance);
        }
        List variableComponents = typeDefinitionNode.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).filter(reference -> reference.getTargetNodeClass() == NodeClass.Variable).map(r -> this.nodeMap.getNode(r.getTargetNodeId())).flatMap(StreamUtil::opt2stream).map(UaVariableNode.class::cast).collect(Collectors.toList());
        for (UaVariableNode declaration : variableComponents) {
            boolean placeholder = declaration.getReferences().stream().anyMatch(r -> r.isForward() && r.getReferenceTypeId().equals((Object)Identifiers.HasModellingRule) && (Identifiers.ModellingRule_OptionalPlaceholder.expanded().equals((Object)r.getTargetNodeId()) || Identifiers.ModellingRule_MandatoryPlaceholder.expanded().equals((Object)r.getTargetNodeId()) || Identifiers.ModellingRule_ExposesItsArray.expanded().equals((Object)r.getTargetNodeId())));
            if (placeholder) continue;
            UaVariableTypeNode typeDefinition = (UaVariableTypeNode)declaration.getTypeDefinitionNode();
            NodeId instanceId = this.createNodeId(nodeId, declaration.getBrowseName().getName());
            UaVariableNode instance = this.createVariable(instanceId, typeDefinition.getNodeId());
            instance.setBrowseName(declaration.getBrowseName());
            instance.setDisplayName(declaration.getDisplayName());
            instance.setDescription(declaration.getDescription());
            instance.setWriteMask(declaration.getWriteMask());
            instance.setUserWriteMask(declaration.getUserWriteMask());
            instance.setValue(declaration.getValue());
            instance.setDataType(declaration.getDataType());
            instance.setValueRank(declaration.getValueRank());
            instance.setArrayDimensions(declaration.getArrayDimensions());
            this.addComponent(node, instance);
            this.nodeMap.addNode(instance);
        }
        if (node instanceof ObjectNode) {
            List objectComponents = typeDefinitionNode.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).filter(reference -> reference.getTargetNodeClass() == NodeClass.Object).map(r -> this.nodeMap.getNode(r.getTargetNodeId())).flatMap(StreamUtil::opt2stream).map(UaObjectNode.class::cast).collect(Collectors.toList());
            for (UaObjectNode declaration : objectComponents) {
                boolean placeholder = declaration.getReferences().stream().anyMatch(r -> r.isForward() && r.getReferenceTypeId().equals((Object)Identifiers.HasModellingRule) && (Identifiers.ModellingRule_OptionalPlaceholder.expanded().equals((Object)r.getTargetNodeId()) || Identifiers.ModellingRule_MandatoryPlaceholder.expanded().equals((Object)r.getTargetNodeId()) || Identifiers.ModellingRule_ExposesItsArray.expanded().equals((Object)r.getTargetNodeId())));
                if (placeholder) continue;
                UaObjectTypeNode typeDefinition = (UaObjectTypeNode)declaration.getTypeDefinitionNode();
                NodeId instanceId = this.createNodeId(nodeId, declaration.getBrowseName().getName());
                UaObjectNode instance = this.createObject(instanceId, typeDefinition.getNodeId());
                instance.setBrowseName(declaration.getBrowseName());
                instance.setDisplayName(declaration.getDisplayName());
                instance.setDescription(declaration.getDescription());
                instance.setWriteMask(declaration.getWriteMask());
                instance.setUserWriteMask(declaration.getUserWriteMask());
                instance.setEventNotifier(declaration.getEventNotifier());
                this.addComponent(node, instance);
                this.nodeMap.addNode(instance);
            }
        }
        return (T)((Node)clazz.cast(node));
    }

    private UaObjectNode instanceFromTypeDefinition(NodeId nodeId, ObjectTypeNode typeDefinitionNode) {
        NodeId typeDefinitionId = typeDefinitionNode.getNodeId();
        ObjectTypeManager.ObjectNodeConstructor ctor = this.objectTypeManager.getNodeFactory(typeDefinitionId).orElseThrow(() -> new UaRuntimeException(2153971712L, "no NodeFactory for type definition: " + typeDefinitionId));
        UaObjectNode objectNode = ctor.apply(this.nodeMap, nodeId, typeDefinitionNode.getBrowseName(), typeDefinitionNode.getDisplayName(), typeDefinitionNode.getDescription(), typeDefinitionNode.getWriteMask(), typeDefinitionNode.getUserWriteMask());
        objectNode.addReference(new Reference(objectNode.getNodeId(), Identifiers.HasTypeDefinition, typeDefinitionId.expanded(), NodeClass.ObjectType, true));
        return objectNode;
    }

    private UaVariableNode instanceFromTypeDefinition(NodeId nodeId, VariableTypeNode typeDefinitionNode) {
        NodeId typeDefinitionId = typeDefinitionNode.getNodeId();
        VariableTypeManager.VariableNodeConstructor ctor = this.variableTypeManager.getNodeFactory(typeDefinitionId).orElseThrow(() -> new UaRuntimeException(2153971712L, "no NodeFactory for type definition: " + typeDefinitionId));
        UaVariableNode variableNode = ctor.apply(this.nodeMap, nodeId, typeDefinitionNode.getBrowseName(), typeDefinitionNode.getDisplayName(), typeDefinitionNode.getDescription(), typeDefinitionNode.getWriteMask(), typeDefinitionNode.getUserWriteMask());
        variableNode.setValue(typeDefinitionNode.getValue());
        variableNode.setDataType(typeDefinitionNode.getDataType());
        variableNode.setValueRank(typeDefinitionNode.getValueRank());
        variableNode.setArrayDimensions(typeDefinitionNode.getArrayDimensions());
        variableNode.addReference(new Reference(variableNode.getNodeId(), Identifiers.HasTypeDefinition, typeDefinitionId.expanded(), NodeClass.VariableType, true));
        return variableNode;
    }

    private void addComponent(UaNode sourceNode, UaNode targetNode) {
        sourceNode.addReference(new Reference(sourceNode.getNodeId(), Identifiers.HasComponent, targetNode.getNodeId().expanded(), targetNode.getNodeClass(), true));
        targetNode.addReference(new Reference(targetNode.getNodeId(), Identifiers.HasComponent, sourceNode.getNodeId().expanded(), sourceNode.getNodeClass(), false));
    }

    private NodeId createNodeId(NodeId nodeId, String toAppend) {
        return new NodeId(nodeId.getNamespaceIndex(), nodeId.getIdentifier() + "." + toAppend);
    }
}

