/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.methods;

import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.annotations.UaInputArgument;
import org.eclipse.milo.opcua.sdk.server.annotations.UaMethod;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredDataItem;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.util.AnnotationBasedInvocationHandler;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class ResendData {
    private final OpcUaServer server;

    public ResendData(OpcUaServer server) {
        this.server = server;
    }

    @UaMethod
    public void invoke(AnnotationBasedInvocationHandler.InvocationContext context, @UaInputArgument(name="subscriptionId") UInteger subscriptionId) throws UaException {
        Session session = context.getSession().orElse(null);
        if (session != null) {
            Subscription subscription = session.getSubscriptionManager().getSubscription(subscriptionId);
            if (subscription == null) {
                context.setFailure(new UaException(0x80280000L));
            } else {
                subscription.getMonitoredItems().values().stream().filter(item -> item instanceof MonitoredDataItem).map(item -> (MonitoredDataItem)item).forEach(MonitoredDataItem::clearLastValue);
            }
        } else {
            context.setFailure(new UaException(2149515264L));
        }
    }
}

